/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.dao.impl;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.persistence.AttributeNode;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.Subgraph;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.FetchParent;
import javax.persistence.criteria.From;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.PageSpecification;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dao.Selector;
import org.cxbox.api.data.dao.UpdateSpecification;
import org.cxbox.api.exception.ServerException;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.model.core.api.EmbeddedKeyable;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.core.dao.impl.ScrollableResultsIterator;
import org.cxbox.model.core.dao.util.JpaUtils;
import org.cxbox.model.core.entity.AbstractEntity;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.core.entity.BaseEntity_;
import org.hibernate.Hibernate;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Primary
@Transactional
public class JpaDaoImpl
implements JpaDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JpaDaoImpl.class);
    final Set<EntityManager> entityManagers;
    @Lazy
    protected final TransactionService txService;

    public JpaDaoImpl(Set<EntityManager> entityManagers, TransactionService txService) {
        this.txService = txService;
        this.entityManagers = entityManagers;
    }

    protected EntityManager getSupportedEntityManager(String entityClazz) {
        List supportedEntityManagers = this.entityManagers.stream().filter(entityManager -> entityManager.getMetamodel().getEntities().stream().anyMatch(entityType -> Objects.equal((Object)entityType.getBindableJavaType().getSimpleName(), (Object)entityClazz) || Objects.equal((Object)entityType.getBindableJavaType().getName(), (Object)entityClazz))).collect(Collectors.toList());
        if (supportedEntityManagers.size() == 1) {
            return (EntityManager)supportedEntityManagers.get(0);
        }
        throw new IllegalArgumentException("Can't find unique EntityManager for entity: " + entityClazz);
    }

    @Override
    public <T extends BaseEntity> T findById(String type, Long id) {
        EntityType<BaseEntity> entityType = this.getEntityType(type);
        if (entityType == null) {
            throw new IllegalArgumentException(type);
        }
        return this.findById(entityType.getJavaType(), id);
    }

    @Override
    public <T extends BaseEntity> T findById(Class<T> clazz, Long id) {
        return (T)((BaseEntity)((Session)this.getSupportedEntityManager(clazz.getName()).unwrap(Session.class)).get(clazz, (Serializable)id));
    }

    @Override
    public <T> EntityGraph<? super T> getEntityGraph(Class<T> clazz, String name) {
        return this.getSupportedEntityManager(clazz.getName()).getEntityGraphs(clazz).stream().filter(graph -> name.equals(graph.getName())).findFirst().orElse(null);
    }

    @Override
    public <T> void applyGraph(Class<T> clazz, Root<T> root, String fetchGraph) {
        this.applyGraph(root, this.getEntityGraph(clazz, fetchGraph));
    }

    @Override
    public <T, X> List<T> getList(Class<T> clazz, SingularAttribute<T, X> name, X value) {
        return this.getList(clazz, (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(name), value));
    }

    @Override
    public <T> void applyGraph(Root<T> root, EntityGraph<? super T> fetchGraph) {
        if (fetchGraph == null) {
            return;
        }
        this.applyFetches((FetchParent)root, fetchGraph.getAttributeNodes());
    }

    private void applyFetches(FetchParent fetch, List<AttributeNode<?>> nodes) {
        for (AttributeNode<?> node : nodes) {
            String attributeName = node.getAttributeName();
            Fetch child = fetch.fetch(attributeName, this.getJoinType(fetch, attributeName));
            for (Subgraph subgraph : node.getSubgraphs().values()) {
                this.applyFetches((FetchParent)child, subgraph.getAttributeNodes());
            }
        }
    }

    protected JoinType getJoinType(FetchParent fetch, String attrName) {
        if (fetch instanceof From) {
            return this.getJoinType((From)fetch, attrName);
        }
        return JoinType.LEFT;
    }

    protected JoinType getJoinType(From from, String attrName) {
        ManagedType managedType;
        JoinType joinType = JoinType.INNER;
        Bindable model = from.getModel();
        if (model.getBindableType() == Bindable.BindableType.ENTITY_TYPE && (managedType = (ManagedType)model).getAttribute(attrName).isAssociation()) {
            joinType = JoinType.LEFT;
        }
        return joinType;
    }

    @Override
    public <T> List<T> getListByIds(Class<T> clazz, List<Long> ids) {
        return this.getList(clazz, (Specification & Serializable)(root, query, cb) -> cb.or((Predicate[])ids.stream().map(id -> cb.equal((Expression)root.get("id"), id)).toArray(Predicate[]::new)));
    }

    @Override
    public Long getCount(Class<?> clazz) {
        return this.getCount(clazz, (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[0]));
    }

    @Override
    public <T> Long getCount(Class<T> entityClass, Specification<T> specification) {
        return this.getSingleResult(entityClass, Long.class, (root, cb) -> cb.count((Expression)root), specification);
    }

    @Override
    public void flush() {
        if (this.txService.isActive()) {
            this.entityManagers.forEach(EntityManager::flush);
        }
    }

    @Override
    public void clear() {
        if (this.txService.isActive()) {
            this.entityManagers.forEach(EntityManager::clear);
        }
    }

    @Override
    public void refresh(AbstractEntity o) {
        EntityManager supportedEntityManager = this.getSupportedEntityManager(Hibernate.getClass((Object)o).getName());
        if (supportedEntityManager.contains((Object)o)) {
            ((Session)supportedEntityManager.unwrap(Session.class)).refresh((Object)o);
        }
    }

    @Override
    public <T> T save(Object entity) {
        return (T)((Session)this.getSupportedEntityManager(Hibernate.getClass((Object)entity).getName()).unwrap(Session.class)).save(entity);
    }

    @Override
    public <T> List<T> saveAll(List<T> entities) {
        return entities.stream().map(this::save).collect(Collectors.toList());
    }

    @Override
    public <T extends BaseEntity> T evict(T o) {
        ((Session)this.getSupportedEntityManager(Hibernate.getClass(o).getName()).unwrap(Session.class)).evict(o);
        return o;
    }

    @Override
    public void delete(AbstractEntity o) {
        EntityManager supportedEntityManager = this.getSupportedEntityManager(Hibernate.getClass((Object)o).getName());
        ((Session)supportedEntityManager.unwrap(Session.class)).delete(supportedEntityManager.merge((Object)o));
    }

    @Override
    public <T extends BaseEntity> T delete(Class<T> clazz, Long id) {
        T o = this.findById(clazz, id);
        if (o == null) {
            throw new EntityNotFoundException();
        }
        ((Session)this.getSupportedEntityManager(clazz.getName()).unwrap(Session.class)).delete(o);
        return o;
    }

    @Override
    public <T> List<T> getList(Class<T> entityClass) {
        return this.getList(entityClass, null);
    }

    @Override
    public <T> int delete(Class<T> entityClass, Specification<T> spec) {
        CriteriaBuilder cb = this.getSupportedEntityManager(entityClass.getName()).getCriteriaBuilder();
        CriteriaDelete delete = cb.createCriteriaDelete(entityClass);
        Root root = delete.from(entityClass);
        if (spec != null) {
            delete.where((Expression)spec.toPredicate(root, cb.createQuery(), cb));
        }
        return this.getSupportedEntityManager(entityClass.getName()).createQuery(delete).executeUpdate();
    }

    @Override
    public <T> int update(Class<T> entityClass, Specification<T> spec, UpdateSpecification<T> updateSpec) {
        CriteriaBuilder cb = this.getSupportedEntityManager(entityClass.getName()).getCriteriaBuilder();
        CriteriaUpdate update = cb.createCriteriaUpdate(entityClass);
        Root root = update.from(entityClass);
        if (spec != null) {
            update.where((Expression)spec.toPredicate(root, cb.createQuery(), cb));
        }
        updateSpec.apply(update, root, cb);
        return this.getSupportedEntityManager(entityClass.getName()).createQuery(update).executeUpdate();
    }

    @Override
    public void saveWithCompositeKey(EmbeddedKeyable o) {
        ((Session)this.getSupportedEntityManager(Hibernate.getClass((Object)o).getName()).unwrap(Session.class)).save((Object)o);
    }

    @Override
    public void deleteWithCompositeKey(EmbeddedKeyable o) {
        ((Session)this.getSupportedEntityManager(Hibernate.getClass((Object)o).getName()).unwrap(Session.class)).delete((Object)o);
    }

    @Override
    public <T> List<Long> getIds(Class<T> entityClazz, Specification<T> searchSpec) {
        return this.getList(entityClazz, Long.class, (root, cb) -> root.get("id"), searchSpec);
    }

    @Override
    public void lock(AbstractEntity entity, LockModeType lockMode, int timeout) {
        if (lockMode != LockModeType.PESSIMISTIC_READ && lockMode != LockModeType.PESSIMISTIC_WRITE) {
            throw new ServerException("Only pessimistic lock modes are supported");
        }
        if (!this.canLock(entity)) {
            return;
        }
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        options.put("javax.persistence.lock.timeout", timeout);
        this.getSupportedEntityManager(Hibernate.getClass((Object)entity).getName()).lock((Object)entity, lockMode, options);
    }

    @Override
    public void lockAndRefresh(AbstractEntity entity, int timeout) {
        if (!this.canLock(entity)) {
            return;
        }
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        options.put("javax.persistence.lock.timeout", timeout);
        this.getSupportedEntityManager(Hibernate.getClass((Object)entity).getName()).lock((Object)entity, LockModeType.PESSIMISTIC_READ, options);
        this.getSupportedEntityManager(Hibernate.getClass((Object)entity).getName()).refresh((Object)entity);
    }

    @Override
    public void revert(AbstractEntity entity) {
        if (this.canLock(entity)) {
            this.refresh(entity);
        }
    }

    private boolean canLock(AbstractEntity entity) {
        return !entity.isNew();
    }

    @Override
    public <T> List<T> selectNativeQuery(Class<T> entityClazz, String sql, Map<String, Object> params) {
        Query query = this.getSupportedEntityManager(entityClazz.getName()).createNativeQuery(sql, entityClazz);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query.getResultList();
    }

    @Override
    public <T> List<T> getList(Class<T> entityClass, Specification<T> specification) {
        return this.getPage(entityClass, specification, null).getResult();
    }

    @Override
    public <R, T> List<T> getList(Class<R> rootClass, Class<T> targetClass, Selector<R, T> selector, Specification<R> specification) {
        return this.getPage(rootClass, targetClass, selector, specification, null).getResult();
    }

    @Override
    public <T> ResultPage<T> getPage(Class<T> entityClass, Specification<T> specification, PageSpecification page) {
        return this.getPage(entityClass, entityClass, Selector.identity(), specification, page);
    }

    @Override
    @Transactional(propagation=Propagation.MANDATORY)
    public <T> Stream<T> getStream(Class<T> entityClass, Specification<T> specification) {
        return this.getStream(entityClass, entityClass, Selector.identity(), specification);
    }

    @Override
    public <T> T getSingleResult(Class<T> entityClass, Specification<T> specification) {
        return this.getSingleResult(entityClass, entityClass, Selector.identity(), specification);
    }

    @Override
    public <T extends BaseEntity> T fetchBySpecification(Class<T> entityClass, Specification<T> specification) {
        Long id = this.getSingleResult(entityClass, Long.class, (root, cb) -> root.get(BaseEntity_.id), specification);
        return this.findById(entityClass, id);
    }

    @Override
    public <T> T getSingleResultOrNull(Class<T> entityClass, Specification<T> specification) {
        return this.getSingleResultOrNull(entityClass, entityClass, Selector.identity(), specification);
    }

    @Override
    public <T> T getFirstResultOrNull(Class<T> entityClass, Specification<T> specification) {
        return this.getFirstResultOrNull(entityClass, entityClass, Selector.identity(), specification);
    }

    @Override
    public <T> boolean exists(Class<T> entityClass, Specification<T> specification) {
        return this.getCount(entityClass, specification) > 0L;
    }

    protected <T> TypedQuery<T> applyPaging(TypedQuery<T> query, PageSpecification page) {
        if (PageSpecification.isValid((PageSpecification)page)) {
            return query.setFirstResult(page.getFrom()).setMaxResults(page.getPageSize() + 1);
        }
        return query;
    }

    @Override
    public <R, T> ResultPage<T> getPage(Class<R> rootClass, Class<T> targetClass, Selector<R, T> selector, Specification<R> specification, PageSpecification page) {
        TypedQuery<T> query = this.getTypedQuery(rootClass, targetClass, selector, specification);
        List result = this.applyPaging(query, page).getResultList();
        return ResultPage.of((List)result, (PageSpecification)page);
    }

    @Override
    @Transactional(propagation=Propagation.MANDATORY)
    public <R, T> Stream<T> getStream(Class<R> rootClass, Class<T> targetClass, Selector<R, T> selector, Specification<R> specification) {
        return this.asStream(this.getTypedQuery(rootClass, targetClass, selector, specification));
    }

    @Override
    public <R, T> T getSingleResult(Class<R> rootClass, Class<T> targetClass, Selector<R, T> selector, Specification<R> specification) {
        return JpaUtils.getSingleResult(this.getTypedQuery(rootClass, targetClass, selector, specification));
    }

    @Override
    public <R, T> T getSingleResultOrNull(Class<R> rootClass, Class<T> targetClass, Selector<R, T> selector, Specification<R> specification) {
        return JpaUtils.getSingleResultOrNull(this.getTypedQuery(rootClass, targetClass, selector, specification));
    }

    @Override
    public <R, T> T getFirstResultOrNull(Class<R> rootClass, Class<T> targetClass, Selector<R, T> selector, Specification<R> specification) {
        return JpaUtils.getFirstResultOrNull(this.getTypedQuery(rootClass, targetClass, selector, specification).setMaxResults(1));
    }

    protected <R, T> TypedQuery<T> getTypedQuery(Class<R> rootClass, Class<T> targetClass, Selector<R, T> selector, Specification<R> specification) {
        EntityManager supportedEntityManager = this.getSupportedEntityManager(rootClass.getName());
        CriteriaBuilder cb = supportedEntityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(targetClass);
        Root root = query.from(rootClass);
        query.select(selector.select(root, cb));
        if (specification != null) {
            query.where((Expression)specification.toPredicate(root, query, cb));
        }
        return supportedEntityManager.createQuery(query);
    }

    protected <T> Stream<T> asStream(TypedQuery<T> query) {
        org.hibernate.query.Query hibernateQuery = (org.hibernate.query.Query)query.unwrap(org.hibernate.query.Query.class);
        ScrollableResults results = hibernateQuery.scroll(ScrollMode.FORWARD_ONLY);
        ScrollableResultsIterator iterator = new ScrollableResultsIterator(results);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        Stream stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(iterator::close);
    }

    protected EntityType<BaseEntity> getEntityType(String name) {
        return this.getSupportedEntityManager(name).getMetamodel().getEntities().stream().filter(type -> StringUtils.equalsIgnoreCase((CharSequence)type.getName(), (CharSequence)name) && BaseEntity.class.isAssignableFrom(type.getJavaType())).map(EntityType.class::cast).findAny().orElseThrow(IllegalArgumentException::new);
    }

    @Override
    public <T> EntityType<T> getEntityType(Class<T> cls) {
        return this.getSupportedEntityManager(cls.getName()).getMetamodel().entity(cls);
    }
}

