/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.dao.impl;

import java.io.Closeable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hibernate.ScrollableResults;

class ScrollableResultsIterator<T>
implements Iterator<T>,
Closeable {
    private final ScrollableResults scrollableResults;
    private T next;
    private boolean closed;

    ScrollableResultsIterator(ScrollableResults scrollableResults) {
        this.scrollableResults = scrollableResults;
    }

    @Override
    public void close() {
        this.closed = true;
        this.scrollableResults.close();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.closed) {
            return false;
        }
        if (this.scrollableResults.next()) {
            this.next = this.getObject();
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T current = this.next;
            this.next = null;
            return current;
        }
        throw new NoSuchElementException();
    }

    private T getObject() {
        Object[] object = this.scrollableResults.get();
        Object result = object.length == 1 ? object[0] : object;
        return (T)result;
    }
}

