/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.dao.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.ParameterMode;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.SingularAttribute;
import lombok.Generated;
import org.cxbox.model.core.entity.BaseEntity;
import org.hibernate.Hibernate;

public final class JpaUtils {
    public static <T> T getSingleResult(TypedQuery<T> typedQuery) {
        List resultList = typedQuery.getResultList();
        if (resultList.isEmpty()) {
            throw new NoResultException();
        }
        if (resultList.size() == 1) {
            return (T)resultList.get(0);
        }
        throw new NonUniqueResultException("result returns more than one elements");
    }

    public static <T> T getSingleResultOrNull(TypedQuery<T> typedQuery) {
        List resultList = typedQuery.getResultList();
        if (resultList.isEmpty()) {
            return null;
        }
        if (resultList.size() == 1) {
            return (T)resultList.get(0);
        }
        throw new NonUniqueResultException("result returns more than one elements");
    }

    public static <T> T getFirstResultOrNull(TypedQuery<T> typedQuery) {
        List resultList = typedQuery.getResultList();
        if (resultList.isEmpty()) {
            return null;
        }
        return (T)resultList.get(0);
    }

    public static void executeNativeQuery(EntityManager entityManager, String sql, Object ... params) {
        Query query = entityManager.createNativeQuery(sql);
        JpaUtils.bindParameters(query, params);
        query.executeUpdate();
    }

    public static <T> List<T> selectNativeQuery(EntityManager entityManager, String sql, Object ... params) {
        Query query = entityManager.createNativeQuery(sql);
        JpaUtils.bindParameters(query, params);
        return query.getResultList();
    }

    public static <T> List<T> selectNativeQuery(EntityManager entityManager, Class<T> resultClass, String sql, Object ... params) {
        Query query = entityManager.createNativeQuery(sql, resultClass);
        JpaUtils.bindParameters(query, params);
        return query.getResultList();
    }

    public static Map<String, Object> executeStoredProcedure(EntityManager entityManager, String procedureName, Map<Integer, Object> input, List<String> output) {
        StoredProcedureQuery query = entityManager.createStoredProcedureQuery(procedureName);
        input.forEach((key, value) -> {
            query.registerStoredProcedureParameter(key.intValue(), value.getClass(), ParameterMode.IN);
            query.setParameter(key.intValue(), value);
        });
        output.forEach(param -> query.registerStoredProcedureParameter(param, String.class, ParameterMode.OUT));
        query.execute();
        HashMap<String, Object> result = new HashMap<String, Object>();
        output.forEach(param -> result.put((String)param, query.getOutputParameterValue(param)));
        return result;
    }

    private static void bindParameters(Query query, Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i + 1, params[i]);
        }
    }

    public static <X, Z, Y> Join<X, Z> addJoin(From<Y, X> from, SingularAttribute<X, Z> attribute, JoinType joinType) {
        Set joins = from.getJoins();
        Join existedJoin = joins.stream().filter(join -> join.getAttribute().equals(attribute)).findFirst().orElse(null);
        if (existedJoin == null) {
            return from.join(attribute, joinType);
        }
        return existedJoin;
    }

    public static Class unproxiedClass(BaseEntity proxy) {
        return Hibernate.getClass((Object)proxy);
    }

    @Generated
    private JpaUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

