/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.core.entity.Department;
import org.cxbox.model.core.entity.UserDivisions;
import org.cxbox.model.core.entity.UserRole;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;

@Audited
@Entity
@Table(name="users")
public class User
extends BaseEntity
implements ManagedEntity,
SelfDirtinessTracker {
    private String login;
    private String firstName;
    private String lastName;
    private String patronymic;
    private String phone;
    private String email;
    private String fullUserName;
    private String title;
    @Column(name="ext_attr_11")
    private String extensionAttribute11;
    @Column(name="ext_attr_12")
    private String extensionAttribute12;
    @Column(name="ext_attr_13")
    private String extensionAttribute13;
    @Column(name="ext_attr_14")
    private String extensionAttribute14;
    @Column(name="ext_attr_15")
    private String extensionAttribute15;
    @Column(name="DN")
    private String dn;
    @NotAudited
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id", insertable=false, updatable=false)
    private UserDivisions userDivisions;
    private String origDeptCode;
    @ManyToOne
    @JoinColumn(name="dept_id")
    private Department department;
    @JsonIgnore
    private String password;
    @Deprecated
    @Column(name="internal_role_cd")
    private LOV internalRole;
    @NotAudited
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user")
    private List<UserRole> userRoleList;
    private LOV timezone;
    private LOV locale;
    private String userPrincipalName;
    @Column(name="active")
    private Boolean active;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public String getFullName() {
        StringBuilder sB = new StringBuilder();
        if (this.$$_hibernate_read_lastName() != null) {
            sB.append(this.$$_hibernate_read_lastName());
            if (this.$$_hibernate_read_firstName() != null || this.$$_hibernate_read_patronymic() != null) {
                sB.append(" ");
            }
        }
        if (this.$$_hibernate_read_firstName() != null) {
            sB.append(this.$$_hibernate_read_firstName());
            if (this.$$_hibernate_read_patronymic() != null) {
                sB.append(" ");
            }
        }
        if (this.$$_hibernate_read_patronymic() != null) {
            sB.append(this.$$_hibernate_read_patronymic());
        }
        return sB.toString();
    }

    public String getUserNameInitials() {
        StringBuilder sB = new StringBuilder();
        if (this.$$_hibernate_read_lastName() != null) {
            sB.append(this.$$_hibernate_read_lastName());
            if (this.$$_hibernate_read_firstName() != null || this.$$_hibernate_read_patronymic() != null) {
                sB.append(" ");
            }
        }
        if (this.$$_hibernate_read_firstName() != null) {
            sB.append(StringUtils.left((String)this.$$_hibernate_read_firstName(), (int)1).toUpperCase() + ".");
            if (this.$$_hibernate_read_patronymic() != null) {
                sB.append(" ");
            }
        }
        if (this.$$_hibernate_read_patronymic() != null) {
            sB.append(StringUtils.left((String)this.$$_hibernate_read_patronymic(), (int)1).toUpperCase() + ".");
        }
        return sB.toString();
    }

    public String getUserNameInitialsWithoutSpace() {
        StringBuilder sB = new StringBuilder();
        if (this.$$_hibernate_read_lastName() != null) {
            sB.append(this.$$_hibernate_read_lastName());
            if (this.$$_hibernate_read_firstName() != null || this.$$_hibernate_read_patronymic() != null) {
                sB.append(" ");
            }
        }
        if (this.$$_hibernate_read_firstName() != null) {
            sB.append(StringUtils.left((String)this.$$_hibernate_read_firstName(), (int)1).toUpperCase() + ".");
        }
        if (this.$$_hibernate_read_patronymic() != null) {
            sB.append(StringUtils.left((String)this.$$_hibernate_read_patronymic(), (int)1).toUpperCase() + ".");
        }
        return sB.toString();
    }

    public ZoneId getZoneId() {
        return Optional.ofNullable(this.getTimezone()).map(t -> ZoneId.of(t.getKey())).orElseGet(ZoneId::systemDefault);
    }

    @Generated
    public String getLogin() {
        return this.$$_hibernate_read_login();
    }

    @Generated
    public String getFirstName() {
        return this.$$_hibernate_read_firstName();
    }

    @Generated
    public String getLastName() {
        return this.$$_hibernate_read_lastName();
    }

    @Generated
    public String getPatronymic() {
        return this.$$_hibernate_read_patronymic();
    }

    @Generated
    public String getPhone() {
        return this.$$_hibernate_read_phone();
    }

    @Generated
    public String getEmail() {
        return this.$$_hibernate_read_email();
    }

    @Generated
    public String getFullUserName() {
        return this.$$_hibernate_read_fullUserName();
    }

    @Generated
    public String getTitle() {
        return this.$$_hibernate_read_title();
    }

    @Generated
    public String getExtensionAttribute11() {
        return this.$$_hibernate_read_extensionAttribute11();
    }

    @Generated
    public String getExtensionAttribute12() {
        return this.$$_hibernate_read_extensionAttribute12();
    }

    @Generated
    public String getExtensionAttribute13() {
        return this.$$_hibernate_read_extensionAttribute13();
    }

    @Generated
    public String getExtensionAttribute14() {
        return this.$$_hibernate_read_extensionAttribute14();
    }

    @Generated
    public String getExtensionAttribute15() {
        return this.$$_hibernate_read_extensionAttribute15();
    }

    @Generated
    public String getDn() {
        return this.$$_hibernate_read_dn();
    }

    @Generated
    public UserDivisions getUserDivisions() {
        return this.$$_hibernate_read_userDivisions();
    }

    @Generated
    public String getOrigDeptCode() {
        return this.$$_hibernate_read_origDeptCode();
    }

    @Generated
    public Department getDepartment() {
        return this.$$_hibernate_read_department();
    }

    @Generated
    public String getPassword() {
        return this.$$_hibernate_read_password();
    }

    @Deprecated
    @Generated
    public LOV getInternalRole() {
        return this.$$_hibernate_read_internalRole();
    }

    @Generated
    public List<UserRole> getUserRoleList() {
        return this.$$_hibernate_read_userRoleList();
    }

    @Generated
    public LOV getTimezone() {
        return this.$$_hibernate_read_timezone();
    }

    @Generated
    public LOV getLocale() {
        return this.$$_hibernate_read_locale();
    }

    @Generated
    public String getUserPrincipalName() {
        return this.$$_hibernate_read_userPrincipalName();
    }

    @Generated
    public Boolean getActive() {
        return this.$$_hibernate_read_active();
    }

    @Generated
    public void setLogin(String login) {
        this.$$_hibernate_write_login(login);
    }

    @Generated
    public void setFirstName(String firstName) {
        this.$$_hibernate_write_firstName(firstName);
    }

    @Generated
    public void setLastName(String lastName) {
        this.$$_hibernate_write_lastName(lastName);
    }

    @Generated
    public void setPatronymic(String patronymic) {
        this.$$_hibernate_write_patronymic(patronymic);
    }

    @Generated
    public void setPhone(String phone) {
        this.$$_hibernate_write_phone(phone);
    }

    @Generated
    public void setEmail(String email) {
        this.$$_hibernate_write_email(email);
    }

    @Generated
    public void setFullUserName(String fullUserName) {
        this.$$_hibernate_write_fullUserName(fullUserName);
    }

    @Generated
    public void setTitle(String title) {
        this.$$_hibernate_write_title(title);
    }

    @Generated
    public void setExtensionAttribute11(String extensionAttribute11) {
        this.$$_hibernate_write_extensionAttribute11(extensionAttribute11);
    }

    @Generated
    public void setExtensionAttribute12(String extensionAttribute12) {
        this.$$_hibernate_write_extensionAttribute12(extensionAttribute12);
    }

    @Generated
    public void setExtensionAttribute13(String extensionAttribute13) {
        this.$$_hibernate_write_extensionAttribute13(extensionAttribute13);
    }

    @Generated
    public void setExtensionAttribute14(String extensionAttribute14) {
        this.$$_hibernate_write_extensionAttribute14(extensionAttribute14);
    }

    @Generated
    public void setExtensionAttribute15(String extensionAttribute15) {
        this.$$_hibernate_write_extensionAttribute15(extensionAttribute15);
    }

    @Generated
    public void setDn(String dn) {
        this.$$_hibernate_write_dn(dn);
    }

    @Generated
    public void setUserDivisions(UserDivisions userDivisions) {
        this.$$_hibernate_write_userDivisions(userDivisions);
    }

    @Generated
    public void setOrigDeptCode(String origDeptCode) {
        this.$$_hibernate_write_origDeptCode(origDeptCode);
    }

    @Generated
    public void setDepartment(Department department) {
        this.$$_hibernate_write_department(department);
    }

    @JsonIgnore
    @Generated
    public void setPassword(String password) {
        this.$$_hibernate_write_password(password);
    }

    @Deprecated
    @Generated
    public void setInternalRole(LOV internalRole) {
        this.$$_hibernate_write_internalRole(internalRole);
    }

    @Generated
    public void setUserRoleList(List<UserRole> userRoleList) {
        this.$$_hibernate_write_userRoleList(userRoleList);
    }

    @Generated
    public void setTimezone(LOV timezone) {
        this.$$_hibernate_write_timezone(timezone);
    }

    @Generated
    public void setLocale(LOV locale) {
        this.$$_hibernate_write_locale(locale);
    }

    @Generated
    public void setUserPrincipalName(String userPrincipalName) {
        this.$$_hibernate_write_userPrincipalName(userPrincipalName);
    }

    @Generated
    public void setActive(Boolean active) {
        this.$$_hibernate_write_active(active);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        User user = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        block0: {
            if (this.$$_hibernate_tracker == null) break block0;
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        User user = this;
        user = null;
        user = NoopCollectionTracker.INSTANCE;
        return user;
    }

    public String $$_hibernate_read_login() {
        return this.login;
    }

    public void $$_hibernate_write_login(String string) {
        if (!Objects.deepEquals(string, this.login)) {
            this.$$_hibernate_trackChange("login");
        }
        this.login = string;
    }

    public String $$_hibernate_read_firstName() {
        return this.firstName;
    }

    public void $$_hibernate_write_firstName(String string) {
        if (!Objects.deepEquals(string, this.firstName)) {
            this.$$_hibernate_trackChange("firstName");
        }
        this.firstName = string;
    }

    public String $$_hibernate_read_lastName() {
        return this.lastName;
    }

    public void $$_hibernate_write_lastName(String string) {
        if (!Objects.deepEquals(string, this.lastName)) {
            this.$$_hibernate_trackChange("lastName");
        }
        this.lastName = string;
    }

    public String $$_hibernate_read_patronymic() {
        return this.patronymic;
    }

    public void $$_hibernate_write_patronymic(String string) {
        if (!Objects.deepEquals(string, this.patronymic)) {
            this.$$_hibernate_trackChange("patronymic");
        }
        this.patronymic = string;
    }

    public String $$_hibernate_read_phone() {
        return this.phone;
    }

    public void $$_hibernate_write_phone(String string) {
        if (!Objects.deepEquals(string, this.phone)) {
            this.$$_hibernate_trackChange("phone");
        }
        this.phone = string;
    }

    public String $$_hibernate_read_email() {
        return this.email;
    }

    public void $$_hibernate_write_email(String string) {
        if (!Objects.deepEquals(string, this.email)) {
            this.$$_hibernate_trackChange("email");
        }
        this.email = string;
    }

    public String $$_hibernate_read_fullUserName() {
        return this.fullUserName;
    }

    public void $$_hibernate_write_fullUserName(String string) {
        if (!Objects.deepEquals(string, this.fullUserName)) {
            this.$$_hibernate_trackChange("fullUserName");
        }
        this.fullUserName = string;
    }

    public String $$_hibernate_read_title() {
        return this.title;
    }

    public void $$_hibernate_write_title(String string) {
        if (!Objects.deepEquals(string, this.title)) {
            this.$$_hibernate_trackChange("title");
        }
        this.title = string;
    }

    public String $$_hibernate_read_extensionAttribute11() {
        return this.extensionAttribute11;
    }

    public void $$_hibernate_write_extensionAttribute11(String string) {
        if (!Objects.deepEquals(string, this.extensionAttribute11)) {
            this.$$_hibernate_trackChange("extensionAttribute11");
        }
        this.extensionAttribute11 = string;
    }

    public String $$_hibernate_read_extensionAttribute12() {
        return this.extensionAttribute12;
    }

    public void $$_hibernate_write_extensionAttribute12(String string) {
        if (!Objects.deepEquals(string, this.extensionAttribute12)) {
            this.$$_hibernate_trackChange("extensionAttribute12");
        }
        this.extensionAttribute12 = string;
    }

    public String $$_hibernate_read_extensionAttribute13() {
        return this.extensionAttribute13;
    }

    public void $$_hibernate_write_extensionAttribute13(String string) {
        if (!Objects.deepEquals(string, this.extensionAttribute13)) {
            this.$$_hibernate_trackChange("extensionAttribute13");
        }
        this.extensionAttribute13 = string;
    }

    public String $$_hibernate_read_extensionAttribute14() {
        return this.extensionAttribute14;
    }

    public void $$_hibernate_write_extensionAttribute14(String string) {
        if (!Objects.deepEquals(string, this.extensionAttribute14)) {
            this.$$_hibernate_trackChange("extensionAttribute14");
        }
        this.extensionAttribute14 = string;
    }

    public String $$_hibernate_read_extensionAttribute15() {
        return this.extensionAttribute15;
    }

    public void $$_hibernate_write_extensionAttribute15(String string) {
        if (!Objects.deepEquals(string, this.extensionAttribute15)) {
            this.$$_hibernate_trackChange("extensionAttribute15");
        }
        this.extensionAttribute15 = string;
    }

    public String $$_hibernate_read_dn() {
        return this.dn;
    }

    public void $$_hibernate_write_dn(String string) {
        if (!Objects.deepEquals(string, this.dn)) {
            this.$$_hibernate_trackChange("dn");
        }
        this.dn = string;
    }

    public UserDivisions $$_hibernate_read_userDivisions() {
        return this.userDivisions;
    }

    public void $$_hibernate_write_userDivisions(UserDivisions userDivisions) {
        if (!Objects.deepEquals(userDivisions, this.userDivisions)) {
            this.$$_hibernate_trackChange("userDivisions");
        }
        this.userDivisions = userDivisions;
    }

    public String $$_hibernate_read_origDeptCode() {
        return this.origDeptCode;
    }

    public void $$_hibernate_write_origDeptCode(String string) {
        if (!Objects.deepEquals(string, this.origDeptCode)) {
            this.$$_hibernate_trackChange("origDeptCode");
        }
        this.origDeptCode = string;
    }

    public Department $$_hibernate_read_department() {
        return this.department;
    }

    public void $$_hibernate_write_department(Department department) {
        if (!Objects.deepEquals(department, this.department)) {
            this.$$_hibernate_trackChange("department");
        }
        this.department = department;
    }

    public String $$_hibernate_read_password() {
        return this.password;
    }

    public void $$_hibernate_write_password(String string) {
        if (!Objects.deepEquals(string, this.password)) {
            this.$$_hibernate_trackChange("password");
        }
        this.password = string;
    }

    public LOV $$_hibernate_read_internalRole() {
        return this.internalRole;
    }

    public void $$_hibernate_write_internalRole(LOV lOV) {
        if (!Objects.deepEquals(lOV, this.internalRole)) {
            this.$$_hibernate_trackChange("internalRole");
        }
        this.internalRole = lOV;
    }

    public List $$_hibernate_read_userRoleList() {
        return this.userRoleList;
    }

    public void $$_hibernate_write_userRoleList(List list) {
        this.userRoleList = list;
    }

    public LOV $$_hibernate_read_timezone() {
        return this.timezone;
    }

    public void $$_hibernate_write_timezone(LOV lOV) {
        if (!Objects.deepEquals(lOV, this.timezone)) {
            this.$$_hibernate_trackChange("timezone");
        }
        this.timezone = lOV;
    }

    public LOV $$_hibernate_read_locale() {
        return this.locale;
    }

    public void $$_hibernate_write_locale(LOV lOV) {
        if (!Objects.deepEquals(lOV, this.locale)) {
            this.$$_hibernate_trackChange("locale");
        }
        this.locale = lOV;
    }

    public String $$_hibernate_read_userPrincipalName() {
        return this.userPrincipalName;
    }

    public void $$_hibernate_write_userPrincipalName(String string) {
        if (!Objects.deepEquals(string, this.userPrincipalName)) {
            this.$$_hibernate_trackChange("userPrincipalName");
        }
        this.userPrincipalName = string;
    }

    public Boolean $$_hibernate_read_active() {
        return this.active;
    }

    public void $$_hibernate_write_active(Boolean bl) {
        if (!Objects.deepEquals(bl, this.active)) {
            this.$$_hibernate_trackChange("active");
        }
        this.active = bl;
    }

    @Override
    public Long $$_hibernate_read_id() {
        return super.$$_hibernate_read_id();
    }

    @Override
    public void $$_hibernate_write_id(Long l) {
        super.$$_hibernate_write_id(l);
    }

    @Override
    public long $$_hibernate_read_vstamp() {
        return super.$$_hibernate_read_vstamp();
    }

    @Override
    public void $$_hibernate_write_vstamp(long l) {
        if (l != ((BaseEntity)this).$$_hibernate_read_vstamp()) {
            this.$$_hibernate_trackChange("vstamp");
        }
        super.$$_hibernate_write_vstamp(l);
    }

    @Override
    public LocalDateTime $$_hibernate_read_createdDate() {
        return super.$$_hibernate_read_createdDate();
    }

    @Override
    public void $$_hibernate_write_createdDate(LocalDateTime localDateTime) {
        if (!Objects.deepEquals(localDateTime, ((BaseEntity)this).$$_hibernate_read_createdDate())) {
            this.$$_hibernate_trackChange("createdDate");
        }
        super.$$_hibernate_write_createdDate(localDateTime);
    }

    @Override
    public LocalDateTime $$_hibernate_read_updatedDate() {
        return super.$$_hibernate_read_updatedDate();
    }

    @Override
    public void $$_hibernate_write_updatedDate(LocalDateTime localDateTime) {
        if (!Objects.deepEquals(localDateTime, ((BaseEntity)this).$$_hibernate_read_updatedDate())) {
            this.$$_hibernate_trackChange("updatedDate");
        }
        super.$$_hibernate_write_updatedDate(localDateTime);
    }

    @Override
    public Long $$_hibernate_read_createdBy() {
        return super.$$_hibernate_read_createdBy();
    }

    @Override
    public void $$_hibernate_write_createdBy(Long l) {
        if (!Objects.deepEquals(l, ((BaseEntity)this).$$_hibernate_read_createdBy())) {
            this.$$_hibernate_trackChange("createdBy");
        }
        super.$$_hibernate_write_createdBy(l);
    }

    @Override
    public Long $$_hibernate_read_lastUpdBy() {
        return super.$$_hibernate_read_lastUpdBy();
    }

    @Override
    public void $$_hibernate_write_lastUpdBy(Long l) {
        if (!Objects.deepEquals(l, ((BaseEntity)this).$$_hibernate_read_lastUpdBy())) {
            this.$$_hibernate_trackChange("lastUpdBy");
        }
        super.$$_hibernate_write_lastUpdBy(l);
    }
}

