/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.listeners.hbn;

import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import org.cxbox.api.config.CxboxBeanProperties;
import org.cxbox.model.core.listeners.hbn.change.ChangeInterceptor;
import org.cxbox.model.core.listeners.hbn.flush.FlushInterceptor;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEntityEvent;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DatabaseListener
implements PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener,
FlushEntityEventListener,
FlushEventListener,
AutoFlushEventListener {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CxboxBeanProperties cxboxBeanProperties;
    @Autowired
    private ChangeInterceptor changeInterceptor;
    @Autowired
    private FlushInterceptor flushInterceptor;

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }

    public void onPostDelete(PostDeleteEvent event) {
        this.changeInterceptor.addEvent(event);
    }

    public void onPostInsert(PostInsertEvent event) {
        this.changeInterceptor.addEvent(event);
    }

    public void onPostUpdate(PostUpdateEvent event) {
        this.changeInterceptor.addEvent(event);
    }

    public void onAutoFlush(AutoFlushEvent event) throws HibernateException {
        this.flushInterceptor.onFlush(event);
    }

    public void onFlushEntity(FlushEntityEvent event) throws HibernateException {
        this.flushInterceptor.onFlush(event);
    }

    public void onFlush(FlushEvent event) throws HibernateException {
        this.flushInterceptor.onFlush(event);
    }

    @PostConstruct
    protected void init() {
        this.prependListener(EventType.POST_INSERT, this);
        this.prependListener(EventType.POST_UPDATE, this);
        this.prependListener(EventType.POST_DELETE, this);
        this.appendListener(EventType.FLUSH_ENTITY, this);
        this.appendListener(EventType.FLUSH, this);
        this.appendListener(EventType.AUTO_FLUSH, this);
    }

    private EventListenerRegistry getRegistry() {
        SessionFactoryImplementor implementor = (SessionFactoryImplementor)((EntityManagerFactory)this.applicationContext.getBean(this.cxboxBeanProperties.getEntityManagerFactory(), EntityManagerFactory.class)).unwrap(SessionFactoryImplementor.class);
        return (EventListenerRegistry)implementor.getServiceRegistry().getService(EventListenerRegistry.class);
    }

    private <T> void prependListener(EventType<T> eventType, T listener) {
        this.getRegistry().getEventListenerGroup(eventType).prependListener(listener);
    }

    private <T> void appendListener(EventType<T> eventType, T listener) {
        this.getRegistry().getEventListenerGroup(eventType).appendListener(listener);
    }
}

