/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.listeners.hbn.change;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cxbox.model.core.listeners.hbn.EntityId;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.persister.entity.EntityPersister;

public class ChangeEventHolder {
    private final Map<EntityId, AbstractEvent> events = new LinkedHashMap<EntityId, AbstractEvent>();

    public Collection<AbstractEvent> getEvents() {
        return this.events.values();
    }

    public AbstractEvent getEvent(EntityId entityId) {
        return this.events.get(entityId);
    }

    public void clear() {
        this.events.clear();
    }

    protected void addEvent(PostInsertEvent event) {
        this.events.compute(this.getEntityId(event), (entityId, current) -> this.merge((AbstractEvent)current, event));
    }

    protected void addEvent(PostUpdateEvent event) {
        this.events.compute(this.getEntityId(event), (entityId, current) -> this.merge((AbstractEvent)current, event));
    }

    protected void addEvent(PostDeleteEvent event) {
        this.events.compute(this.getEntityId(event), (entityId, current) -> this.merge((AbstractEvent)current, event));
    }

    private EntityId getEntityId(PostInsertEvent event) {
        return new EntityId(event.getId(), event.getPersister().getEntityName());
    }

    private EntityId getEntityId(PostUpdateEvent event) {
        return new EntityId(event.getId(), event.getPersister().getEntityName());
    }

    private EntityId getEntityId(PostDeleteEvent event) {
        return new EntityId(event.getId(), event.getPersister().getEntityName());
    }

    private Object[] getOldState(PostUpdateEvent event) {
        Object[] oldState = event.getOldState();
        if (oldState != null) {
            return oldState;
        }
        EntityPersister persister = event.getPersister();
        return persister.getDatabaseSnapshot(event.getId(), (SharedSessionContractImplementor)event.getSession());
    }

    protected AbstractEvent merge(AbstractEvent existing, PostInsertEvent event) {
        return event;
    }

    protected AbstractEvent merge(AbstractEvent existing, PostUpdateEvent event) {
        if (existing == null) {
            return new PostUpdateEvent(event.getEntity(), event.getId(), event.getState(), this.getOldState(event), event.getDirtyProperties(), event.getPersister(), event.getSession());
        }
        if (existing instanceof PostInsertEvent) {
            return new PostInsertEvent(event.getEntity(), event.getId(), event.getState(), event.getPersister(), event.getSession());
        }
        if (existing instanceof PostUpdateEvent) {
            return new PostUpdateEvent(event.getEntity(), event.getId(), event.getState(), ((PostUpdateEvent)existing).getOldState(), event.getDirtyProperties(), event.getPersister(), event.getSession());
        }
        return null;
    }

    protected AbstractEvent merge(AbstractEvent existing, PostDeleteEvent event) {
        if (existing == null) {
            return event;
        }
        if (existing instanceof PostInsertEvent) {
            return null;
        }
        if (existing instanceof PostUpdateEvent) {
            return event;
        }
        return null;
    }
}

