/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.listeners.hbn.change;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.cxbox.api.data.dao.databaselistener.IChangeListener;
import org.cxbox.api.data.dao.databaselistener.IChangeVector;
import org.cxbox.api.data.dao.databaselistener.InterimChangeListener;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.api.util.Invoker;
import org.cxbox.model.core.api.EntitySerializationEvent;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.core.listeners.hbn.EntityId;
import org.cxbox.model.core.listeners.hbn.change.ChangeEventHolder;
import org.cxbox.model.core.listeners.hbn.change.ChangeVectorFactory;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.internal.SessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ChangeInterceptor
implements ApplicationListener<EntitySerializationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChangeInterceptor.class);
    private final Map<Transaction, ChangeEventHolder> events = new ConcurrentHashMap<Transaction, ChangeEventHolder>();
    private final Optional<List<IChangeListener>> changeListeners;
    private final List<EntityManager> entityManagers;
    private final TransactionService txService;

    public ChangeInterceptor(Optional<List<IChangeListener>> changeListeners, List<EntityManager> entityManagers, TransactionService txService) {
        this.changeListeners = changeListeners;
        this.entityManagers = entityManagers;
        this.txService = txService;
    }

    private EntityManager getSupportedEntityManager(String entityClazz) {
        List supportedEntityManagers = this.entityManagers.stream().filter(entityManager -> entityManager.getMetamodel().getEntities().stream().anyMatch(entityType -> com.google.common.base.Objects.equal((Object)entityType.getBindableJavaType().getName(), (Object)entityClazz))).collect(Collectors.toList());
        if (supportedEntityManagers.size() == 1) {
            return (EntityManager)supportedEntityManagers.get(0);
        }
        throw new IllegalArgumentException("Can't find unique EntityManager for entity: " + entityClazz);
    }

    public void onApplicationEvent(EntitySerializationEvent serializationEvent) {
        Transaction transaction;
        ChangeEventHolder eventHolder;
        if (!this.txService.isActive()) {
            return;
        }
        BaseEntity entity = serializationEvent.getEntity();
        SessionImpl session = (SessionImpl)this.getSupportedEntityManager(Hibernate.getClass((Object)entity).getName()).unwrap(SessionImpl.class);
        session.flush();
        if (this.needRefresh((Session)session, entity)) {
            session.refresh((Object)entity);
        }
        if ((eventHolder = this.events.get(transaction = session.getTransaction())) == null) {
            return;
        }
        String name = session.getEntityName((Object)entity);
        AbstractEvent event = eventHolder.getEvent(new EntityId(entity.getId(), name));
        if (event != null) {
            this.processEvent(event, InterimChangeListener.class);
        }
    }

    private boolean needRefresh(Session session, BaseEntity entity) {
        if (!session.contains((Object)entity) || entity.isNew()) {
            return false;
        }
        return !Objects.equals(entity.getVstamp(), entity.getLoadVstamp());
    }

    private boolean isSupported(PostDeleteEvent event) {
        return this.changeListeners.map(changeListeners -> changeListeners.stream().anyMatch(g -> g.isSupported(event.getEntity()))).orElse(false);
    }

    private boolean isSupported(PostInsertEvent event) {
        return this.changeListeners.map(changeListeners -> changeListeners.stream().anyMatch(g -> g.isSupported(event.getEntity()))).orElse(false);
    }

    private boolean isSupported(PostUpdateEvent event) {
        return this.changeListeners.map(changeListeners -> changeListeners.stream().anyMatch(g -> g.isSupported(event.getEntity()))).orElse(false);
    }

    public void addEvent(PostDeleteEvent event) {
        if (this.isSupported(event)) {
            EventSource session = event.getSession();
            this.events.computeIfAbsent(session.getTransaction(), this.registerTransaction(session)).addEvent(event);
        }
    }

    public void addEvent(PostInsertEvent event) {
        if (this.isSupported(event)) {
            EventSource session = event.getSession();
            this.events.computeIfAbsent(session.getTransaction(), this.registerTransaction(session)).addEvent(event);
        }
    }

    public void addEvent(PostUpdateEvent event) {
        if (this.isSupported(event)) {
            EventSource session = event.getSession();
            this.events.computeIfAbsent(session.getTransaction(), this.registerTransaction(session)).addEvent(event);
        }
    }

    private Function<Transaction, ChangeEventHolder> registerTransaction(EventSource session) {
        return transaction -> {
            session.getActionQueue().registerProcess((success, implementor) -> this.events.remove(transaction));
            session.getActionQueue().registerProcess(implementor -> this.processAllEvents(this.events.get(transaction)));
            return new ChangeEventHolder();
        };
    }

    private void processAllEvents(ChangeEventHolder eventHolder) {
        if (!this.txService.isActive()) {
            return;
        }
        this.txService.woAutoFlush(Invoker.of(() -> {
            eventHolder.getEvents().forEach(event -> this.processEvent((AbstractEvent)event, (Class<?>)IChangeListener.class));
            eventHolder.clear();
            this.txService.flush();
        }));
    }

    private void processEvent(AbstractEvent event, Class<?> listenerClass) {
        this.processEvent(ChangeVectorFactory.getVector(event), listenerClass);
    }

    public void processEvent(IChangeVector vector, Class<?> listenerClass) {
        this.processEvent(vector, null, listenerClass);
    }

    public void processEvent(IChangeVector vector, LOV eventName) {
        this.processEvent(vector, eventName, IChangeListener.class);
    }

    private void processEvent(IChangeVector vector, LOV eventName, Class<?> listenerClass) {
        try {
            this.doProcessEvent(vector, eventName, listenerClass);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private void doProcessEvent(IChangeVector vector, LOV eventName, Class<?> listenerClass) {
        this.changeListeners.ifPresent(changeListeners -> {
            for (IChangeListener changeListener : changeListeners) {
                if (!listenerClass.isInstance(changeListener) || !changeListener.canProcess(vector, eventName)) continue;
                changeListener.process(vector, eventName);
            }
        });
    }
}

