/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.listeners.hbn.change;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.persistence.metamodel.Attribute;
import org.cxbox.api.data.dao.databaselistener.IChangeVector;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dictionary.LOV;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostUpdateEvent;

class ChangeVectorFactory {
    ChangeVectorFactory() {
    }

    static IChangeVector getVector(AbstractEvent event) {
        if (event instanceof PostUpdateEvent) {
            return new UpdateVector((PostUpdateEvent)event);
        }
        if (event instanceof PostInsertEvent) {
            return new InsertVector((PostInsertEvent)event);
        }
        if (event instanceof PostDeleteEvent) {
            return new DeleteVector((PostDeleteEvent)event);
        }
        throw new RuntimeException("Unsupported event " + event.getClass());
    }

    static class DeleteVector
    implements IChangeVector {
        private final PostDeleteEvent event;

        private DeleteVector(PostDeleteEvent event) {
            this.event = event;
        }

        public LOV getEventName() {
            return CoreDictionaries.DatabaseEventType.DELETE;
        }

        public Object getEntity() {
            return this.event.getEntity();
        }

        public boolean isDelete() {
            return true;
        }

        public boolean hasChanged(Attribute<?, ?> attribute) {
            return true;
        }
    }

    static class InsertVector
    implements IChangeVector {
        private final PostInsertEvent event;

        private InsertVector(PostInsertEvent event) {
            this.event = event;
        }

        public LOV getEventName() {
            return CoreDictionaries.DatabaseEventType.INSERT;
        }

        public Object getEntity() {
            return this.event.getEntity();
        }

        public boolean isNew() {
            return true;
        }

        public boolean hasChanged(Attribute<?, ?> attribute) {
            return true;
        }
    }

    static class UpdateVector
    implements IChangeVector {
        private final PostUpdateEvent event;
        private final Map<String, Integer> names;

        private UpdateVector(PostUpdateEvent event) {
            this.event = event;
            this.names = new HashMap<String, Integer>();
            String[] attributes = event.getPersister().getPropertyNames();
            for (int i = 0; i < attributes.length; ++i) {
                this.names.put(attributes[i], i);
            }
        }

        public LOV getEventName() {
            return CoreDictionaries.DatabaseEventType.UPDATE;
        }

        public Object getEntity() {
            return this.event.getEntity();
        }

        public boolean isUpdate() {
            return true;
        }

        public boolean hasChanged(Attribute<?, ?> attribute) {
            Object[] oldState = this.event.getOldState();
            Object[] state = this.event.getState();
            if (oldState != null && state != null && this.names.containsKey(attribute.getName())) {
                int index = this.names.get(attribute.getName());
                return !Objects.equals(oldState[index], state[index]);
            }
            return false;
        }

        public <T> T getOldValue(Attribute<?, ?> attribute) {
            Object[] oldState = this.event.getOldState();
            if (oldState != null && this.names.containsKey(attribute.getName())) {
                int index = this.names.get(attribute.getName());
                return (T)oldState[index];
            }
            return null;
        }
    }
}

