/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.listeners.hbn.flush;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.cxbox.api.service.tx.ITransactionStatus;
import org.cxbox.model.core.api.RefreshOnFlush;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEntityEvent;
import org.hibernate.event.spi.FlushEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlushInterceptor {
    private final Map<Transaction, Set<RefreshOnFlush>> entities = new ConcurrentHashMap<Transaction, Set<RefreshOnFlush>>();
    @Autowired
    private ITransactionStatus txStatus;

    public void onFlush(FlushEntityEvent event) {
        Object entity = event.getEntity();
        if (!(entity instanceof RefreshOnFlush)) {
            return;
        }
        if (this.txStatus.isCommitting()) {
            return;
        }
        EventSource session = event.getSession();
        this.entities.computeIfAbsent(session.getTransaction(), this.registerTransaction(session)).add((RefreshOnFlush)entity);
    }

    public void onFlush(FlushEvent event) {
        this.performRefresh(event.getSession(), true);
    }

    public void onFlush(AutoFlushEvent event) {
        this.performRefresh(event.getSession(), event.isFlushRequired());
    }

    private void performRefresh(EventSource session, boolean flushRequired) {
        if (!flushRequired) {
            return;
        }
        Set<RefreshOnFlush> pending = this.getSnapshot((Session)session);
        if (pending == null || this.txStatus.isCommitting()) {
            return;
        }
        pending.forEach(e -> {
            if (session.contains(e) && e.needRefresh()) {
                session.refresh(e);
            }
        });
    }

    private Function<Transaction, Set<RefreshOnFlush>> registerTransaction(EventSource session) {
        return transaction -> {
            session.getActionQueue().registerProcess((success, implementor) -> this.entities.remove(transaction));
            session.getActionQueue().registerProcess(implementor -> this.entities.remove(transaction));
            return this.createIdentitySet();
        };
    }

    private Set<RefreshOnFlush> getSnapshot(Session session) {
        return this.entities.replace(session.getTransaction(), this.createIdentitySet());
    }

    private <T> Set<T> createIdentitySet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }
}

