/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.service;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import lombok.Generated;
import org.cxbox.model.core.api.CurrentUserAware;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.core.entity.User;
import org.cxbox.model.core.service.BaseEntityListenerDelegate;

public class CxboxBaseEntityListenerDelegate
implements BaseEntityListenerDelegate {
    private final CurrentUserAware<User> currentUserAware;

    @Override
    public void baseEntityOnLoad(BaseEntity baseEntity) {
        baseEntity.setLoadVstamp(baseEntity.getVstamp());
    }

    @Override
    public void baseEntityOnCreate(BaseEntity baseEntity) {
        baseEntity.setCreatedDate(LocalDateTime.now());
        baseEntity.setUpdatedDate(LocalDateTime.now());
        Long currentUser = baseEntity.getCreatedBy();
        if (currentUser == null) {
            currentUser = this.currentUserAware.getCurrentUser().getId();
        }
        if (currentUser != null) {
            baseEntity.setCreatedBy(currentUser);
            baseEntity.setLastUpdBy(currentUser);
        }
    }

    @Override
    public void baseEntityOnUpdate(BaseEntity baseEntity) {
        Long currentUser = this.currentUserAware.getCurrentUser().getId();
        baseEntity.setUpdatedDate(LocalDateTime.now());
        if (currentUser != null) {
            baseEntity.setLastUpdBy(currentUser);
        }
    }

    @ConstructorProperties(value={"currentUserAware"})
    @Generated
    public CxboxBaseEntityListenerDelegate(CurrentUserAware<User> currentUserAware) {
        this.currentUserAware = currentUserAware;
    }
}

