/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.service;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.LocaleUtils;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.service.LocaleService;
import org.cxbox.api.system.ISystemSettingChangeEventListener;
import org.cxbox.api.system.SystemSettingChangedEvent;
import org.cxbox.api.system.SystemSettings;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service(value="localeService")
public class LocaleServiceImpl
implements LocaleService,
ISystemSettingChangeEventListener {
    private final SystemSettings systemSettings;
    private Set<String> supportedLanguages;

    public LocaleServiceImpl(SystemSettings systemSettings) {
        this.systemSettings = systemSettings;
        this.supportedLanguages = this.checkLanguages(systemSettings.getListValue(CoreDictionaries.SystemPref.SUPPORTED_LANGUAGES));
    }

    public void onApplicationEvent(SystemSettingChangedEvent event) {
        if (CoreDictionaries.SystemPref.SUPPORTED_LANGUAGES.equals((Object)event.getSetting())) {
            this.supportedLanguages = this.checkLanguages(this.systemSettings.getListValue(CoreDictionaries.SystemPref.SUPPORTED_LANGUAGES));
        }
    }

    public boolean isLanguageSupported(String language) {
        return this.supportedLanguages.contains(language);
    }

    private Set<String> checkLanguages(List<String> supportedLanguages) {
        if (supportedLanguages.isEmpty()) {
            throw new IllegalStateException("Please specify SUPPORTED_LANGUAGES in system settings");
        }
        LocaleService.defaultLocale.set(LocaleUtils.toLocale((String)supportedLanguages.get(0)));
        LocaleContextHolder.setDefaultLocale((Locale)((Locale)defaultLocale.get()));
        return Collections.unmodifiableSet(new LinkedHashSet<String>(supportedLanguages));
    }

    public Locale getDefaultLocale() {
        return (Locale)LocaleService.defaultLocale.get();
    }

    @Generated
    public Set<String> getSupportedLanguages() {
        return this.supportedLanguages;
    }
}

