/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.tx;

import javax.persistence.EntityManagerFactory;
import org.cxbox.api.config.CxboxBeanProperties;
import org.cxbox.api.service.tx.ITransactionStatus;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class CxboxJpaTransactionManagerForceActiveAware
extends JpaTransactionManager {
    private final ITransactionStatus txStatus;

    public CxboxJpaTransactionManagerForceActiveAware(ApplicationContext applicationContext, CxboxBeanProperties cxboxBeanProperties, ITransactionStatus txStatus) {
        super((EntityManagerFactory)applicationContext.getBean(cxboxBeanProperties.getEntityManagerFactory(), EntityManagerFactory.class));
        this.txStatus = txStatus;
    }

    public CxboxJpaTransactionManagerForceActiveAware(EntityManagerFactory emf, ITransactionStatus txStatus) {
        super(emf);
        this.txStatus = txStatus;
    }

    protected void prepareSynchronization(DefaultTransactionStatus status, TransactionDefinition definition) {
        super.prepareSynchronization(status, definition);
        if (!status.isNewTransaction()) {
            return;
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapterCustom());
    }

    class TransactionSynchronizationAdapterCustom
    extends TransactionSynchronizationAdapter {
        TransactionSynchronizationAdapterCustom() {
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public void beforeCommit(boolean readOnly) {
            CxboxJpaTransactionManagerForceActiveAware.this.txStatus.setStatus(1);
        }

        public void beforeCompletion() {
            CxboxJpaTransactionManagerForceActiveAware.this.txStatus.setStatus(2);
        }

        public void afterCommit() {
            CxboxJpaTransactionManagerForceActiveAware.this.txStatus.setStatus(4);
        }

        public void afterCompletion(int status) {
            CxboxJpaTransactionManagerForceActiveAware.this.txStatus.setStatus(8);
        }
    }
}

