/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.service;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.cxbox.api.service.LocaleService;
import org.cxbox.model.core.api.Translatable;
import org.cxbox.model.core.api.Translation;
import org.cxbox.model.core.api.TranslationId;
import org.cxbox.model.core.api.TranslationService;
import org.cxbox.model.core.entity.BaseEntity;
import org.springframework.stereotype.Service;

@Service
public class TranslationServiceImpl
implements TranslationService {
    private final LocaleService localeService;

    @Override
    public <L extends Translation<E, L>, E extends BaseEntity> List<String> getMissingTranslations(E translatable) {
        Set supportedLanguages = this.localeService.getSupportedLanguages();
        ArrayList<String> missingLanguages = new ArrayList<String>(supportedLanguages);
        Map translations = ((Translatable)((Object)translatable)).getTranslations();
        missingLanguages.removeAll(translations.keySet());
        return missingLanguages;
    }

    @Override
    public <L extends Translation<E, L>, E extends BaseEntity> List<L> populate(E translatable) {
        List<String> missingLanguages = this.getMissingTranslations(translatable);
        Optional template = ((Translatable)((Object)translatable)).getTranslation(this.localeService.getDefaultLocale().getLanguage(), null);
        Class cls = ((Translatable)((Object)translatable)).getTranslationType();
        ArrayList<Translation> result = new ArrayList<Translation>();
        for (String language : missingLanguages) {
            Translation copy = template.map(Translation::copyTranslation).orElse((Translation)cls.newInstance());
            copy.setPrimaryEntity(translatable);
            copy.setTranslationId(new TranslationId(language));
            ((Translatable)((Object)translatable)).addTranslation(copy);
            result.add(copy);
        }
        return result;
    }

    @ConstructorProperties(value={"localeService"})
    @Generated
    public TranslationServiceImpl(LocaleService localeService) {
        this.localeService = localeService;
    }
}

