/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.DictionaryCacheLoader;
import org.cxbox.api.data.dictionary.IDictionaryType;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.api.service.LocaleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@DependsOn(value={"deploymentTransactionSupport"})
@Service
public class DictionaryCacheImpl
implements DictionaryCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictionaryCacheImpl.class);
    private final LocaleService localeService;
    private final AtomicReference<Cache> cache;
    private List<DictionaryCacheLoader> loaders;

    public DictionaryCacheImpl(LocaleService localeService, Optional<List<DictionaryCacheLoader>> loaders) {
        this.localeService = localeService;
        this.loaders = loaders.orElseGet(ArrayList::new);
        this.cache = new AtomicReference<Cache>(this.loadCache());
        DictionaryCache.instance.set(this);
    }

    public void reload() {
        this.cache.set(this.loadCache());
    }

    private Cache loadCache() {
        return new Cache(this.localeService, this.loaders).load();
    }

    public SimpleDictionary get(IDictionaryType type, String key) {
        return this.getDictByKey(type.getName(), key);
    }

    public SimpleDictionary get(String type, String key) {
        return this.getDictByKey(type, key);
    }

    public Collection<SimpleDictionary> getAll(IDictionaryType dictionaryType) {
        return this.getAll(dictionaryType.getName());
    }

    public Collection<SimpleDictionary> getAll(String dictionaryType) {
        return Optional.ofNullable(this.cache.get().byKey(this.getLanguage())).map(m -> (Map)m.get(dictionaryType)).map(Map::values).orElse(Collections.emptyList());
    }

    public String lookupValue(LOV key, IDictionaryType type) {
        if (key == null || type == null) {
            return null;
        }
        return this.lookupValue(key, type.getName());
    }

    public String lookupValue(LOV key, String type) {
        if (key == null || type == null) {
            return null;
        }
        SimpleDictionary dto = this.getDictByKey(type, key.getKey());
        if (dto == null) {
            return key.getKey();
        }
        return dto.getValue();
    }

    public String lookupValueNullable(LOV key, IDictionaryType type) {
        if (key == null || type == null) {
            return null;
        }
        SimpleDictionary dto = this.getDictByKey(type, key.getKey());
        return dto != null ? dto.getValue() : null;
    }

    private SimpleDictionary getDictByKey(IDictionaryType type, String key) {
        if (key == null || type == null) {
            return null;
        }
        return this.getDictByKey(type.getName(), key);
    }

    private SimpleDictionary getDictByKey(String type, String key) {
        if (key == null || type == null) {
            return null;
        }
        return Optional.ofNullable(this.cache.get().byKey(this.getLanguage())).map(m -> (Map)m.get(type)).map(m -> (SimpleDictionary)m.get(key)).orElse(null);
    }

    private SimpleDictionary getDictByVal(IDictionaryType type, String val) {
        if (val == null || type == null) {
            return null;
        }
        return this.getDictByVal(type.getName(), val);
    }

    private SimpleDictionary getDictByVal(String type, String val) {
        if (val == null || type == null) {
            return null;
        }
        return Optional.ofNullable(this.cache.get().byValue(this.getLanguage())).map(m -> (Map)m.get(type)).map(m -> (SimpleDictionary)m.get(val)).orElse(null);
    }

    public LOV lookupName(String val, IDictionaryType type) {
        if (val == null || type == null) {
            return new LOV(null);
        }
        return this.lookupName(val, type.getName());
    }

    public LOV lookupName(String val, String type) {
        if (val == null || type == null) {
            return new LOV(null);
        }
        SimpleDictionary dto = this.getDictByVal(type, val);
        if (dto == null) {
            return new LOV(val);
        }
        return new LOV(dto.getKey());
    }

    public boolean containsKey(String key, IDictionaryType type) {
        if (key == null || type == null) {
            return false;
        }
        return this.getDictByKey(type, key) != null;
    }

    public boolean containsKey(LOV key, IDictionaryType type) {
        if (key == null || type == null) {
            return false;
        }
        return this.containsKey(key.getKey(), type);
    }

    public boolean containsValue(String value, IDictionaryType type) {
        if (value == null || type == null) {
            return false;
        }
        return this.getDictByVal(type, value) != null;
    }

    public String getDescription(String key, IDictionaryType type) {
        if (key == null || type == null) {
            return null;
        }
        SimpleDictionary SimpleDictionary2 = this.getDictByKey(type, key);
        if (SimpleDictionary2 != null) {
            return SimpleDictionary2.getDescription();
        }
        return null;
    }

    private String getLanguage() {
        return LocaleContextHolder.getLocale().getLanguage();
    }

    public Set<String> types() {
        return Optional.ofNullable(this.cache.get().byKey(this.getLanguage())).map(Map::keySet).orElse(Collections.emptySet());
    }

    private static class Cache {
        private final List<DictionaryCacheLoader> loaders;
        private final Set<String> languages;
        private final String defaultLanguage;
        private final Map<String, Map<String, Map<String, SimpleDictionary>>> byKey;
        private final Map<String, Map<String, Map<String, SimpleDictionary>>> byValue;

        private Cache(LocaleService localeService, List<DictionaryCacheLoader> loaders) {
            this.loaders = loaders;
            this.languages = localeService.getSupportedLanguages();
            this.defaultLanguage = this.languages.iterator().next();
            this.byKey = new HashMap<String, Map<String, Map<String, SimpleDictionary>>>();
            this.byValue = new HashMap<String, Map<String, Map<String, SimpleDictionary>>>();
            this.languages.forEach(language -> {
                this.byKey.put((String)language, new HashMap());
                this.byValue.put((String)language, new HashMap());
            });
        }

        private Map<String, Map<String, SimpleDictionary>> byKey(String language) {
            return this.byKey.getOrDefault(language, this.byKey.get(this.defaultLanguage));
        }

        private Map<String, Map<String, SimpleDictionary>> byValue(String language) {
            return this.byValue.getOrDefault(language, this.byValue.get(this.defaultLanguage));
        }

        private Cache load() {
            Map<String, Map<String, Map<String, SimpleDictionary>>> data = this.loaders.stream().map(DictionaryCacheLoader::load).flatMap(Collection::stream).filter(dictionary -> StringUtils.isNotBlank((CharSequence)dictionary.getLanguage())).filter(dictionary -> this.languages.contains(dictionary.getLanguage())).collect(Collectors.groupingBy(SimpleDictionary::getLanguage, Collectors.groupingBy(SimpleDictionary::getType, Collectors.toMap(SimpleDictionary::getKey, Function.identity()))));
            this.syncLanguages(data);
            data.forEach((lang, typeaware) -> typeaware.forEach((type, dictmap) -> {
                ArrayList dicts = new ArrayList(dictmap.values());
                dicts.sort(Comparator.comparing(SimpleDictionary::getDisplayOrder, Comparator.nullsLast(Integer::compare)).thenComparing(SimpleDictionary::getKey));
                dicts.forEach(dict -> {
                    this.byKey.get(lang).computeIfAbsent((String)type, v -> new LinkedHashMap()).put(dict.getKey(), dict);
                    this.byValue.get(lang).computeIfAbsent((String)type, v -> new LinkedHashMap()).put(dict.getValue(), dict);
                });
            }));
            return this;
        }

        private void syncLanguages(Map<String, Map<String, Map<String, SimpleDictionary>>> map) {
            Map<String, Map<String, SimpleDictionary>> base = map.get(this.defaultLanguage);
            if (base == null) {
                log.error("No dictionary data for default locale");
                map.clear();
                return;
            }
            this.languages.stream().filter(lang -> !this.defaultLanguage.equals(lang)).forEach(lang -> this.merge(base, map.computeIfAbsent((String)lang, l -> new HashMap())));
        }

        private void merge(Map primary, Map secondary) {
            for (Object key : primary.keySet()) {
                secondary.merge(key, primary.get(key), (oldValue, value) -> {
                    if (oldValue instanceof Map) {
                        this.merge((Map)value, (Map)oldValue);
                        return oldValue;
                    }
                    return oldValue;
                });
            }
            this.cleanup(primary, secondary);
        }

        private void cleanup(Map primary, Map secondary) {
            Iterator iter = secondary.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (!primary.containsKey(key)) {
                    iter.remove();
                    continue;
                }
                Object value = secondary.get(key);
                if (!(value instanceof Map)) continue;
                this.cleanup((Map)primary.get(key), (Map)value);
            }
        }
    }
}

