/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.service;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.LocaleUtils;
import org.cxbox.api.config.CxboxLocalizationProperties;
import org.cxbox.api.service.LocaleService;
import org.springframework.context.i18n.LocaleContextHolder;

public class LocaleServiceImpl
implements LocaleService {
    private Set<String> supportedLanguages;

    public LocaleServiceImpl(CxboxLocalizationProperties localizationProperties) {
        this.supportedLanguages = this.checkLanguages(localizationProperties.getSupportedLanguages());
    }

    public boolean isLanguageSupported(String language) {
        return this.supportedLanguages.contains(language);
    }

    private Set<String> checkLanguages(Set<String> supportedLanguages) {
        if (supportedLanguages.isEmpty()) {
            throw new IllegalStateException("Please specify SUPPORTED_LANGUAGES in system settings");
        }
        LocaleService.defaultLocale.set(LocaleUtils.toLocale((String)((String)supportedLanguages.stream().findFirst().orElseThrow())));
        LocaleContextHolder.setDefaultLocale((Locale)((Locale)defaultLocale.get()));
        return Collections.unmodifiableSet(new LinkedHashSet<String>(supportedLanguages));
    }

    public Locale getDefaultLocale() {
        return (Locale)LocaleService.defaultLocale.get();
    }

    @Generated
    public LocaleServiceImpl() {
    }

    @Generated
    public Set<String> getSupportedLanguages() {
        return this.supportedLanguages;
    }
}

