/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.tx;

import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.api.util.Invoker;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service(value="transactionService")
public class TransactionServiceImpl
implements TransactionService {
    private final List<EntityManager> entityManagers;

    public TransactionServiceImpl(List<EntityManager> entityManagers) {
        this.entityManagers = entityManagers;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public <T, E extends Throwable> T invokeInTx(Invoker<T, E> invoker) throws E {
        return (T)invoker.invoke();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public <T, E extends Throwable> T invokeInNewTx(Invoker<T, E> invoker) throws E {
        return (T)invoker.invoke();
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public <T, E extends Throwable> T invokeNoTx(Invoker<T, E> invoker) throws E {
        return (T)invoker.invoke();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public <T, E extends Throwable> T invokeInNewRollbackOnlyTx(Invoker<T, E> invoker) throws E {
        this.setRollbackOnly();
        return (T)invoker.invoke();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public <T, E extends Throwable> T invokeInNewROTx(Invoker<T, E> invoker) throws E {
        this.setRollbackOnly();
        return (T)invoker.invoke();
    }

    public boolean isRollbackOnly() {
        return TransactionAspectSupport.currentTransactionStatus().isRollbackOnly();
    }

    public void setRollbackOnly() {
        if (this.isActive()) {
            this.entityManagers.forEach(entityManager -> {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                SessionImpl session = (SessionImpl)entityManager.unwrap(SessionImpl.class);
                session.getTransaction().setRollbackOnly();
            });
        }
    }

    public boolean isActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    public <T, E extends RuntimeException> void invokeAfterCompletion(final Invoker<T, E> invoker) throws E {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    if (0 == status) {
                        invoker.invoke();
                    }
                }
            });
        } else {
            invoker.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public <T> T woAutoFlush(Invoker<T, RuntimeException> invoker) {
        Map sessionsWithFlushModes = this.entityManagers.stream().map(entityManager -> (Session)entityManager.unwrap(Session.class)).collect(Collectors.toMap(Function.identity(), Session::getHibernateFlushMode));
        try {
            sessionsWithFlushModes.forEach((session, flushMode) -> session.setHibernateFlushMode(FlushMode.MANUAL));
            Object object = invoker.invoke();
            return (T)object;
        }
        finally {
            sessionsWithFlushModes.forEach(Session::setHibernateFlushMode);
        }
    }

    public void flush() {
        if (this.isActive()) {
            this.entityManagers.forEach(EntityManager::flush);
        }
    }
}

