/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.entity;

import jakarta.persistence.Column;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Generated;
import org.cxbox.model.core.entity.AbstractEntity;
import org.cxbox.model.core.hbn.ExtSequenceStyleGenerator;
import org.cxbox.model.core.hbn.PropagateAnnotations;
import org.cxbox.model.core.listeners.jpa.DelegatingBaseEntityListener;
import org.hibernate.annotations.DiscriminatorOptions;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.Parameter;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.springframework.data.annotation.CreatedDate;

@Audited
@MappedSuperclass
@EntityListeners(value={DelegatingBaseEntityListener.class})
@DiscriminatorOptions(insert=false)
@PropagateAnnotations(value={DiscriminatorOptions.class})
public abstract class BaseEntity
extends AbstractEntity
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="extSequenceGenerator")
    @GenericGenerator(name="extSequenceGenerator", type=ExtSequenceStyleGenerator.class, parameters={@Parameter(name="sequence_name", value="app_seq"), @Parameter(name="increment_size", value="1")})
    @JdbcTypeCode(value=2)
    @Column
    protected Long id;
    @Version
    @NotAudited
    @Column(name="vstamp")
    private long vstamp;
    @CreatedDate
    @Column(name="created_date", nullable=false, updatable=false)
    private LocalDateTime createdDate;
    @Column(name="updated_date", nullable=false)
    private LocalDateTime updatedDate;
    @JdbcTypeCode(value=2)
    @Column(name="CREATED_BY_USER_ID", nullable=false)
    private Long createdBy;
    @JdbcTypeCode(value=2)
    @Column(name="LAST_UPD_BY_USER_ID", nullable=false)
    private Long lastUpdBy;
    @Transient
    private long loadVstamp = -1L;

    public String toString() {
        return String.format("%s:%d", this.getClass().getSimpleName(), this.getId());
    }

    @Generated
    protected BaseEntity(BaseEntityBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.vstamp = b.vstamp;
        this.createdDate = b.createdDate;
        this.updatedDate = b.updatedDate;
        this.createdBy = b.createdBy;
        this.lastUpdBy = b.lastUpdBy;
        this.loadVstamp = b.loadVstamp;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setVstamp(long vstamp) {
        this.vstamp = vstamp;
    }

    @Generated
    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    @Generated
    public void setUpdatedDate(LocalDateTime updatedDate) {
        this.updatedDate = updatedDate;
    }

    @Generated
    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setLastUpdBy(Long lastUpdBy) {
        this.lastUpdBy = lastUpdBy;
    }

    @Generated
    public void setLoadVstamp(long loadVstamp) {
        this.loadVstamp = loadVstamp;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public long getVstamp() {
        return this.vstamp;
    }

    @Generated
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public LocalDateTime getUpdatedDate() {
        return this.updatedDate;
    }

    @Generated
    public Long getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Long getLastUpdBy() {
        return this.lastUpdBy;
    }

    @Generated
    public long getLoadVstamp() {
        return this.loadVstamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseEntity)) {
            return false;
        }
        BaseEntity other = (BaseEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public BaseEntity() {
    }

    @Generated
    public static abstract class BaseEntityBuilder<C extends BaseEntity, B extends BaseEntityBuilder<C, B>>
    extends AbstractEntity.AbstractEntityBuilder<C, B> {
        @Generated
        private Long id;
        @Generated
        private long vstamp;
        @Generated
        private LocalDateTime createdDate;
        @Generated
        private LocalDateTime updatedDate;
        @Generated
        private Long createdBy;
        @Generated
        private Long lastUpdBy;
        @Generated
        private long loadVstamp;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BaseEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BaseEntity instance, BaseEntityBuilder<?, ?> b) {
            b.id(instance.id);
            b.vstamp(instance.vstamp);
            b.createdDate(instance.createdDate);
            b.updatedDate(instance.updatedDate);
            b.createdBy(instance.createdBy);
            b.lastUpdBy(instance.lastUpdBy);
            b.loadVstamp(instance.loadVstamp);
        }

        @Generated
        public B id(Long id) {
            this.id = id;
            return (B)this.self();
        }

        @Generated
        public B vstamp(long vstamp) {
            this.vstamp = vstamp;
            return (B)this.self();
        }

        @Generated
        public B createdDate(LocalDateTime createdDate) {
            this.createdDate = createdDate;
            return (B)this.self();
        }

        @Generated
        public B updatedDate(LocalDateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (B)this.self();
        }

        @Generated
        public B createdBy(Long createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        @Generated
        public B lastUpdBy(Long lastUpdBy) {
            this.lastUpdBy = lastUpdBy;
            return (B)this.self();
        }

        @Generated
        public B loadVstamp(long loadVstamp) {
            this.loadVstamp = loadVstamp;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BaseEntity.BaseEntityBuilder(super=" + super.toString() + ", id=" + this.id + ", vstamp=" + this.vstamp + ", createdDate=" + String.valueOf(this.createdDate) + ", updatedDate=" + String.valueOf(this.updatedDate) + ", createdBy=" + this.createdBy + ", lastUpdBy=" + this.lastUpdBy + ", loadVstamp=" + this.loadVstamp + ")";
        }
    }
}

