/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.service;

import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import org.cxbox.api.service.session.CxboxAuthenticationService;
import org.cxbox.api.service.session.InternalAuthorizationService;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public final class InternalAuthorizationServiceImpl
implements InternalAuthorizationService {
    private final CxboxAuthenticationService cxboxAuthenticationService;

    public InternalAuthorizationServiceImpl(@Lazy CxboxAuthenticationService cxboxAuthenticationService) {
        this.cxboxAuthenticationService = cxboxAuthenticationService;
    }

    public Authentication createAuthentication(@NonNull InternalAuthorizationService.SystemUser systemUser) {
        if (systemUser == null) {
            throw new NullPointerException("systemUser is marked non-null but is null");
        }
        return this.createAuthentication(systemUser.getLogin(), new HashSet<String>());
    }

    public Authentication createAuthentication(@NonNull String login, @NonNull Set<String> userRole) {
        if (login == null) {
            throw new NullPointerException("login is marked non-null but is null");
        }
        if (userRole == null) {
            throw new NullPointerException("userRole is marked non-null but is null");
        }
        UserDetails userDetails = this.cxboxAuthenticationService.loadUserByUsername(login, userRole);
        return new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
    }

    public void loginAs(@NonNull InternalAuthorizationService.SystemUser systemUser) {
        if (systemUser == null) {
            throw new NullPointerException("systemUser is marked non-null but is null");
        }
        this.loginAs(this.createAuthentication(systemUser));
    }

    public void loginAs(@NonNull String login, @NonNull Set<String> userRole) {
        if (login == null) {
            throw new NullPointerException("login is marked non-null but is null");
        }
        if (userRole == null) {
            throw new NullPointerException("userRole is marked non-null but is null");
        }
        this.loginAs(this.createAuthentication(login, userRole));
    }

    public void loginAs(@NonNull Authentication authentication) {
        if (authentication == null) {
            throw new NullPointerException("authentication is marked non-null but is null");
        }
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }
}

