/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.tx;

import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.cxbox.api.service.tx.DeploymentTransactionSupport;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service(value="deploymentTransactionSupport")
public class DeploymentTransactionSupportImpl
implements DeploymentTransactionSupport,
ApplicationListener<ContextRefreshedEvent>,
DisposableBean {
    private final PlatformTransactionManager txManager;
    private final ApplicationContext applicationContext;
    private TransactionStatus deployStatus;

    protected boolean isEnabled() {
        return false;
    }

    @PostConstruct
    public void init() {
        if (this.isEnabled()) {
            this.beginDeploymentTransaction();
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.isEnabled() && this.applicationContext == event.getApplicationContext()) {
            this.commitDeploymentTransaction();
        }
    }

    public void destroy() {
        if (this.isEnabled()) {
            this.rollbackDeploymentTransaction();
        }
    }

    protected void beginDeploymentTransaction() {
        this.deployStatus = this.txManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(0));
    }

    protected void commitDeploymentTransaction() {
        if (this.deployStatus != null) {
            this.txManager.commit(this.deployStatus);
            this.deployStatus = null;
        }
    }

    protected void rollbackDeploymentTransaction() {
        if (this.deployStatus != null) {
            this.txManager.commit(this.deployStatus);
            this.deployStatus = null;
        }
    }

    @ConstructorProperties(value={"txManager", "applicationContext"})
    @Generated
    public DeploymentTransactionSupportImpl(PlatformTransactionManager txManager, ApplicationContext applicationContext) {
        this.txManager = txManager;
        this.applicationContext = applicationContext;
    }
}

