/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.hbn;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.cxbox.model.core.hbn.PropagateAnnotations;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.MetadataProvider;

public class PropagateAnnotationReader
implements AnnotationReader {
    private final AnnotationReader delegate;
    private final MetadataProvider metadataProvider;
    private final Set<Class<? extends Annotation>> propagated;
    private final AnnotationReader parent;

    public PropagateAnnotationReader(AnnotationReader delegate, MetadataProvider metadataProvider, AnnotatedElement annotatedElement) {
        this.delegate = delegate;
        this.metadataProvider = metadataProvider;
        this.propagated = this.getPropagatedAnnotations(annotatedElement);
        this.parent = this.getParentAnnotationReader(annotatedElement);
    }

    private Set<Class<? extends Annotation>> getPropagatedAnnotations(AnnotatedElement annotatedElement) {
        if (!(annotatedElement instanceof Class)) {
            return Collections.emptySet();
        }
        PropagateAnnotations propagateAnnotations = annotatedElement.getAnnotation(PropagateAnnotations.class);
        if (propagateAnnotations == null) {
            return Collections.emptySet();
        }
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        Collections.addAll(result, propagateAnnotations.value());
        return result;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        Annotation result = this.delegate.getAnnotation(annotationType);
        if (result == null && this.propagated.contains(annotationType)) {
            result = Optional.ofNullable(this.parent).map(ar -> ar.getAnnotation(annotationType)).orElse(null);
        }
        return (T)result;
    }

    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationType) {
        boolean result = this.delegate.isAnnotationPresent(annotationType);
        if (!result && this.propagated.contains(annotationType)) {
            result = Optional.ofNullable(this.parent).map(ar -> ar.isAnnotationPresent(annotationType)).orElse(false);
        }
        return result;
    }

    public Annotation[] getAnnotations() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        HashSet<Class<? extends Annotation>> propagated = new HashSet<Class<? extends Annotation>>(this.propagated);
        for (Annotation annotation : this.delegate.getAnnotations()) {
            annotations.add(annotation);
            propagated.remove(annotation.getClass());
        }
        for (Class clazz : propagated) {
            Optional.ofNullable(this.parent).map(ar -> ar.getAnnotation(cls)).ifPresent(annotations::add);
        }
        return annotations.toArray(new Annotation[0]);
    }

    private AnnotationReader getParentAnnotationReader(AnnotatedElement annotatedElement) {
        if (!(annotatedElement instanceof Class) || annotatedElement == Object.class) {
            return null;
        }
        return this.metadataProvider.getAnnotationReader(((Class)annotatedElement).getSuperclass());
    }
}

