/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.hbn;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.model.core.hbn.ExtSequenceGenerator;
import org.cxbox.model.core.hbn.ExtSequenceGeneratorSequenceName;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.annotations.Parameter;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class ExtSequenceStyleGenerator
extends SequenceStyleGenerator {
    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        Class<?> entityClass;
        String entityName = params.getProperty("entity_name");
        if (StringUtils.isNotBlank((CharSequence)entityName) && (entityClass = this.getClassOrNull(entityName)) != null) {
            ExtSequenceGenerator extSequenceGeneratorAnnotation;
            ExtSequenceGeneratorSequenceName sequenceNameAnnotation = entityClass.getAnnotation(ExtSequenceGeneratorSequenceName.class);
            if (sequenceNameAnnotation != null) {
                params.setProperty("sequence_name", sequenceNameAnnotation.value());
            }
            if ((extSequenceGeneratorAnnotation = entityClass.getAnnotation(ExtSequenceGenerator.class)) != null) {
                for (Parameter param : extSequenceGeneratorAnnotation.parameters()) {
                    params.setProperty(param.name(), param.value());
                }
            }
        }
        super.configure(type, params, serviceRegistry);
    }

    public Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        Object currentId = session.getEntityPersister(null, object).getIdentifier(object, session);
        if (currentId != null) {
            return currentId;
        }
        try (SessionImplementor tempSession = session.getFactory().openSession();){
            Object object2 = super.generate((SharedSessionContractImplementor)tempSession.unwrap(SharedSessionContractImplementor.class), object);
            return object2;
        }
    }

    private Class<?> getClassOrNull(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

