/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.service;

import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.CxboxAuthenticationService;
import org.cxbox.api.service.session.InternalAuthorizationService;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public final class InternalAuthorizationServiceImpl
implements InternalAuthorizationService {
    private final CxboxAuthenticationService cxboxAuthenticationService;

    public InternalAuthorizationServiceImpl(@Lazy CxboxAuthenticationService cxboxAuthenticationService) {
        this.cxboxAuthenticationService = cxboxAuthenticationService;
    }

    public Authentication createAuthentication(InternalAuthorizationService.SystemUser systemUser) {
        return this.createAuthentication(systemUser.getLogin(), null);
    }

    public Authentication createAuthentication(String login, LOV userRole) {
        UserDetails userDetails = this.cxboxAuthenticationService.loadUserByUsername(login, userRole);
        return new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
    }

    public void loginAs(InternalAuthorizationService.SystemUser systemUser) {
        this.loginAs(this.createAuthentication(systemUser));
    }

    public void loginAs(String login, LOV userRole) {
        this.loginAs(this.createAuthentication(login, userRole));
    }

    public void loginAs(Authentication authentication) {
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }
}

