/*
 * © OOO "SI IKS LAB", 2022-2023
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.cxbox.meta.navigation;

import jakarta.persistence.Convert;
import org.cxbox.api.data.dictionary.LOV;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * Entity that represent groups in navigation tree.
 * Clients side of cxbox framework uses this to create navigation elements such as tabs or menus
 */
@Getter
@Setter
@Entity(name = "NAVIGATION_GROUP")
@Accessors(chain = true)
public class NavigationGroup {

	/**
	 * Identifier in navigation tree. Also primary key
	 */
	@Id
	@Column(name = "ID")
	protected String id;

	/**
	 * Type of group
	 */
	@Column(name = "TYPE_CD")
	private LOV typeCd;

	/**
	 * Name of screen, where is group located
	 */
	@Column(name = "SCREEN_NAME")
	private String screenName;

	/**
	 * Title of group. Navigation element shows it to user.
	 */
	@Column(name = "TITLE")
	private String title;

	/**
	 * since navigation is a tree, groups can be nested to each other
	 */
	@ManyToOne
	@JoinColumn(name = "PARENT_ID")
	private NavigationGroup parent;

	/**
	 * Sequence of group in a parent element
	 */
	@Column(name = "SEQ")
	private Integer seq;

	/**
	 * description for developers
	 */
	@Column(name = "DESCRIPTION")
	private String description;

	/**
	 * default view, that opens when user click on group;
	 */
	@Column(name = "DEFAULT_VIEW")
	private String defaultView;

	/**
	 * is group hidden on navigation bars
	 */
	@Column(name = "HIDDEN")
	@Convert(converter = org.hibernate.type.NumericBooleanConverter.class)
	private Boolean hidden;

}
