/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.IUser;
import org.cxbox.core.service.ResponsibilitiesService;
import org.cxbox.meta.entity.Responsibilities;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.springframework.cache.annotation.Cacheable;

public class ResponsibilitiesServiceImpl
implements ResponsibilitiesService {
    private final MetaRepository metaRepository;

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="{#root.methodName, #user.id, #userRole}")
    public Map<String, Boolean> getListRespByUser(IUser<Long> user, LOV userRole) {
        return this.metaRepository.getListByUserList(user, userRole, Responsibilities.ResponsibilityType.VIEW).stream().collect(Collectors.toMap(Responsibilities::getView, Responsibilities::isReadOnly, (x1, x2) -> x2));
    }

    public String getListScreensByUser(IUser<Long> user, LOV userRole) {
        return this.metaRepository.getListByUserList(user, userRole, Responsibilities.ResponsibilityType.SCREEN).stream().map(Responsibilities::getScreens).filter(StringUtils::isNotBlank).findFirst().orElse(null);
    }

    @ConstructorProperties(value={"metaRepository"})
    @Generated
    public ResponsibilitiesServiceImpl(MetaRepository metaRepository) {
        this.metaRepository = metaRepository;
    }
}

