/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta;

import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.system.SystemSettingChangedEvent;
import org.cxbox.api.system.SystemSettings;
import org.cxbox.meta.entity.SystemSetting;
import org.cxbox.meta.entity.SystemSetting_;
import org.cxbox.model.core.dao.JpaDao;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@DependsOn(value={"deploymentTransactionSupport"})
@Service(value="systemSettings")
public class SystemSettingsImpl
implements SystemSettings {
    private final JpaDao jpaDao;
    private final ApplicationEventPublisher eventPublisher;
    private final AtomicReference<Map<LOV, String>> settings;

    public SystemSettingsImpl(JpaDao jpaDao, ApplicationEventPublisher eventPublisher) {
        this.jpaDao = jpaDao;
        this.eventPublisher = eventPublisher;
        this.settings = new AtomicReference<Map<LOV, String>>(this.loadSettings());
        instance.set(this);
    }

    public String getValue(LOV key) {
        return this.settings.get().get(key);
    }

    public String getValue(LOV key, String defaultValue) {
        return this.settings.get().getOrDefault(key, defaultValue);
    }

    public boolean getBooleanValue(LOV key) {
        return BooleanUtils.toBoolean((String)this.getValue(key));
    }

    public int getIntegerValue(LOV key, int defaultValue) {
        return NumberUtils.toInt((String)this.getValue(key), (int)defaultValue);
    }

    public long getLongValue(LOV key, long defaultValue) {
        return NumberUtils.toLong((String)this.getValue(key), (long)defaultValue);
    }

    public List<String> getListValue(LOV key) {
        return Optional.ofNullable(this.getValue(key)).map(s -> s.split(",")).map(array -> Arrays.stream(array).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList())).orElse(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        SystemSettingsImpl systemSettingsImpl = this;
        synchronized (systemSettingsImpl) {
            Map<LOV, String> current = this.settings.get();
            Map<LOV, String> pending = this.loadSettings();
            this.settings.set(pending);
            SystemSettingsImpl.disjunction(current.entrySet(), pending.entrySet()).stream().map(Map.Entry::getKey).distinct().map(lov -> new SystemSettingChangedEvent(lov, (Object)this)).forEach(arg_0 -> ((ApplicationEventPublisher)this.eventPublisher).publishEvent(arg_0));
        }
    }

    private static <T> Set<T> disjunction(Set<T> entries1, Set<T> entries2) {
        return entries1.stream().filter(e -> !entries2.contains(e)).collect(Collectors.toSet());
    }

    private Map<LOV, String> loadSettings() {
        return this.jpaDao.getList(SystemSetting.class, (Specification & Serializable)(root, cq, cb) -> cb.isNotNull((Expression)root.get(SystemSetting_.key))).stream().collect(Collectors.toMap(setting -> new LOV(setting.getKey()), SystemSetting::getValue));
    }

    public Stream<? extends Pair<String, String>> select(Predicate<String> predicate) {
        return this.settings.get().entrySet().stream().filter(e -> predicate.test(((LOV)e.getKey()).getKey())).map(e -> ImmutablePair.of((Object)((LOV)e.getKey()).getKey(), (Object)((String)e.getValue())));
    }
}

