/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.IUser;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.api.util.Invoker;
import org.cxbox.core.service.ResponsibilitiesService;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.meta.data.BusinessObjectDTO;
import org.cxbox.meta.data.ScreenNavigation;
import org.cxbox.meta.entity.BcProperties;
import org.cxbox.meta.entity.FilterGroup;
import org.cxbox.meta.entity.Screen;
import org.cxbox.meta.entity.View;
import org.cxbox.meta.entity.ViewWidgets;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.cxbox.meta.navigation.NavigationGroup;
import org.cxbox.meta.navigation.NavigationView;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
public class UIServiceImpl {
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;
    private final ResponsibilitiesService responsibilitiesService;
    private final UICache uiCache;
    private final CacheManager cacheManager;
    private final TransactionService txService;
    private final MetaRepository metaRepository;
    private final SessionService sessionService;

    public Map<String, Boolean> getResponsibilities() {
        return this.getResponsibilities((IUser<Long>)this.sessionService.getSessionUser(), this.sessionService.getSessionUserRole());
    }

    public Map<String, Boolean> getResponsibilities(IUser<Long> user, LOV userRole) {
        return this.responsibilitiesService.getListRespByUser(user, userRole);
    }

    public List<String> getViews(String screenName, IUser<Long> user, LOV userRole) {
        Set<String> responsibilities = this.getResponsibilities(user, userRole).keySet();
        boolean getAll = Objects.equals(userRole, CoreDictionaries.InternalRole.ADMIN);
        return this.metaRepository.getViewByScreenAndResponsibilities(screenName, getAll, responsibilities).stream().map(NavigationView::getViewName).distinct().collect(Collectors.toList());
    }

    public Map<String, BcProperties> getStringDefaultBcPropertiesMap(BusinessObjectDTO boDto) {
        HashMap<String, BcProperties> result = new HashMap<String, BcProperties>(boDto.getBc().size());
        Map<String, BcProperties> allProperties = this.uiCache.getBcProperties();
        boDto.getBc().forEach(bc -> result.put(bc.getName(), (BcProperties)((Object)((Object)allProperties.get(bc.getName())))));
        return result;
    }

    public Map<String, List<FilterGroup>> getFilterGroups(BusinessObjectDTO boDto) {
        HashMap<String, List<FilterGroup>> result = new HashMap<String, List<FilterGroup>>(boDto.getBc().size());
        Map<String, List<FilterGroup>> all = this.uiCache.getFilterGroups();
        boDto.getBc().forEach(bc -> result.put(bc.getName(), (List)all.get(bc.getName())));
        return result;
    }

    public Map<String, List<ViewWidgets>> getAllWidgetsWithPositionByScreen(List<String> views) {
        HashMap<String, List<ViewWidgets>> result = new HashMap<String, List<ViewWidgets>>(views.size());
        Map<String, List<ViewWidgets>> all = this.uiCache.getWidgets();
        views.forEach(view -> result.put((String)view, (List)all.get(view)));
        return result;
    }

    public List<View> getViews(List<String> views) {
        ArrayList<View> result = new ArrayList<View>(views.size());
        Map<String, View> allViews = this.uiCache.getViews();
        views.forEach(view -> result.add((View)((Object)((Object)allViews.get(view)))));
        return result;
    }

    public ScreenNavigation getScreenNavigation(Screen screen) {
        return this.uiCache.getScreenNavigation(screen);
    }

    public void invalidateCache() {
        this.txService.invokeAfterCompletion(Invoker.of(() -> {
            this.cacheManager.getCache("widgetcache").clear();
            this.cacheManager.getCache("userCache").clear();
        }));
    }

    private static void sortMenuItemsBySeq(ScreenNavigation screenNavigation) {
        screenNavigation.getMenu().sort(Comparator.comparingInt(ScreenNavigation.MenuItem::getSeq));
        screenNavigation.getMenu().forEach(UIServiceImpl::recursiveSort);
    }

    private static void recursiveSort(ScreenNavigation.MenuItem m) {
        if (m instanceof ScreenNavigation.ViewGroup) {
            List<ScreenNavigation.MenuItem> child = ((ScreenNavigation.ViewGroup)m).getChild();
            child.sort(Comparator.comparingInt(ScreenNavigation.MenuItem::getSeq));
            child.forEach(UIServiceImpl::recursiveSort);
        }
    }

    @ConstructorProperties(value={"objectMapper", "responsibilitiesService", "uiCache", "cacheManager", "txService", "metaRepository", "sessionService"})
    @Generated
    public UIServiceImpl(@Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper, ResponsibilitiesService responsibilitiesService, UICache uiCache, CacheManager cacheManager, TransactionService txService, MetaRepository metaRepository, SessionService sessionService) {
        this.objectMapper = objectMapper;
        this.responsibilitiesService = responsibilitiesService;
        this.uiCache = uiCache;
        this.cacheManager = cacheManager;
        this.txService = txService;
        this.metaRepository = metaRepository;
        this.sessionService = sessionService;
    }

    @Component
    public static class UICache {
        private final MetaRepository metaRepository;

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.methodName}")
        public Map<String, List<ViewWidgets>> getWidgets() {
            return this.metaRepository.getWidgets();
        }

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.methodName}")
        public Map<String, View> getViews() {
            return this.metaRepository.getViews();
        }

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.methodName}")
        public Map<String, BcProperties> getBcProperties() {
            return this.metaRepository.getBcProperties();
        }

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.methodName}")
        public Map<String, List<FilterGroup>> getFilterGroups() {
            return this.metaRepository.getFilterGroups();
        }

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.methodName, #screen.name}")
        public ScreenNavigation getScreenNavigation(Screen screen) {
            List<ScreenNavigation.MenuItem> childList;
            ScreenNavigation.ViewGroup parentGroup;
            List<NavigationGroup> groups = this.metaRepository.getScreenNavigationGroups(screen);
            List<NavigationView> views = this.metaRepository.getScreenViews(screen);
            ArrayList<ScreenNavigation.MenuItem> firstLevelMenu = new ArrayList<ScreenNavigation.MenuItem>();
            HashMap<String, ScreenNavigation.MenuItem> map = new HashMap<String, ScreenNavigation.MenuItem>();
            for (NavigationGroup navigationGroup : groups) {
                ScreenNavigation.ViewGroup viewGroup = (ScreenNavigation.ViewGroup)map.computeIfAbsent(navigationGroup.getId(), key -> new ScreenNavigation.ViewGroup());
                viewGroup.setId(navigationGroup.getId());
                viewGroup.setHidden(navigationGroup.getHidden());
                viewGroup.setTitle(navigationGroup.getTitle());
                viewGroup.setDefaultView(navigationGroup.getDefaultView());
                viewGroup.setSeq(navigationGroup.getSeq());
                if (navigationGroup.getParent() == null) {
                    firstLevelMenu.add(navigationGroup.getSeq() > firstLevelMenu.size() ? firstLevelMenu.size() : navigationGroup.getSeq().intValue(), viewGroup);
                    continue;
                }
                parentGroup = (ScreenNavigation.ViewGroup)map.computeIfAbsent(navigationGroup.getParent().getId(), key -> new ScreenNavigation.ViewGroup());
                if (parentGroup.getChild() == null) {
                    parentGroup.setChild(new ArrayList<ScreenNavigation.MenuItem>());
                }
                childList = parentGroup.getChild();
                childList.add(navigationGroup.getSeq() > childList.size() ? childList.size() : navigationGroup.getSeq() - 1, viewGroup);
            }
            for (NavigationView view : views) {
                ScreenNavigation.SingleView singleView = new ScreenNavigation.SingleView();
                singleView.setViewName(view.getViewName());
                singleView.setHidden(view.getHidden());
                singleView.setId(view.getId());
                singleView.setSeq(view.getSeq());
                if (view.getParentGroup() == null) {
                    firstLevelMenu.add(view.getSeq() > firstLevelMenu.size() ? firstLevelMenu.size() : view.getSeq().intValue(), singleView);
                    continue;
                }
                parentGroup = (ScreenNavigation.ViewGroup)map.get(view.getParentGroup().getId());
                if (parentGroup.getChild() == null) {
                    parentGroup.setChild(new ArrayList<ScreenNavigation.MenuItem>());
                }
                childList = parentGroup.getChild();
                childList.add(view.getSeq() > childList.size() ? childList.size() : view.getSeq() - 1, singleView);
            }
            ScreenNavigation screenNavigation = new ScreenNavigation();
            screenNavigation.setMenu(firstLevelMenu);
            UIServiceImpl.sortMenuItemsBySeq(screenNavigation);
            return screenNavigation;
        }

        @CacheEvict(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, allEntries=true)
        public void evict() {
        }

        @ConstructorProperties(value={"metaRepository"})
        @Generated
        public UICache(MetaRepository metaRepository) {
            this.metaRepository = metaRepository;
        }
    }

    @Component
    public static class UserCache {
        private final UIServiceImpl uiService;

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"userCache"}, key="{#root.methodName, #user.id, #userRole}")
        public Map<String, Boolean> getResponsibilities(IUser<Long> user, LOV userRole) {
            return this.uiService.getResponsibilities(user, userRole);
        }

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"userCache"}, key="{#root.methodName, #screenName, #user.id, #userRole}")
        public List<String> getViews(String screenName, IUser<Long> user, LOV userRole) {
            return this.uiService.getViews(screenName, user, userRole);
        }

        @ConstructorProperties(value={"uiService"})
        @Generated
        public UserCache(UIServiceImpl uiService) {
            this.uiService = uiService;
        }
    }
}

