/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.mapper;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cxbox.meta.data.ScreenDTO;
import org.cxbox.meta.data.ViewDTO;
import org.cxbox.meta.entity.BcProperties;
import org.cxbox.meta.entity.FilterGroup;
import org.cxbox.meta.metahotreload.dto.ScreenSourceDto;
import org.cxbox.meta.metahotreload.dto.ViewSourceDTO;
import org.cxbox.meta.metahotreload.dto.WidgetSourceDTO;
import org.cxbox.meta.metahotreload.mapper.ScreenMapper;
import org.cxbox.meta.metahotreload.mapper.ViewMapper;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.cxbox.meta.metahotreload.service.MetaResourceReaderService;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class MetaProvider {
    private final MetaResourceReaderService metaResourceReaderService;
    private final MetaRepository metaRepository;
    private final ScreenMapper screenMapper;
    private final ViewMapper viewMapper;

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.methodName}")
    public Map<String, ScreenDTO> getAllScreens() {
        List<ScreenSourceDto> screens = this.metaResourceReaderService.getScreens();
        List<WidgetSourceDTO> widgets = this.metaResourceReaderService.getWidgets();
        List<ViewSourceDTO> views = this.metaResourceReaderService.getViews();
        Map<String, BcProperties> bcProps = this.metaRepository.getBcProperties();
        Map<String, List<FilterGroup>> filterGroups = this.metaRepository.getFilterGroups();
        Map<String, WidgetSourceDTO> widgetNameToWidget = widgets.stream().collect(Collectors.toMap(WidgetSourceDTO::getName, e -> e));
        Map<String, ViewDTO> viewNameToView = views.stream().map(v -> this.viewMapper.map((ViewSourceDTO)v, widgetNameToWidget)).collect(Collectors.toMap(ViewDTO::getName, e -> e));
        return screens.stream().map(screenSourceDto -> this.screenMapper.map((ScreenSourceDto)screenSourceDto, viewNameToView, bcProps, filterGroups)).collect(Collectors.toMap(ScreenDTO::getName, e -> e));
    }

    @ConstructorProperties(value={"metaResourceReaderService", "metaRepository", "screenMapper", "viewMapper"})
    @Generated
    public MetaProvider(MetaResourceReaderService metaResourceReaderService, MetaRepository metaRepository, ScreenMapper screenMapper, ViewMapper viewMapper) {
        this.metaResourceReaderService = metaResourceReaderService;
        this.metaRepository = metaRepository;
        this.screenMapper = screenMapper;
        this.viewMapper = viewMapper;
    }
}

