/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.mapper;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.meta.data.BcSourceBaseDTO;
import org.cxbox.meta.data.BusinessComponentDTO;
import org.cxbox.meta.data.BusinessObjectDTO;
import org.cxbox.meta.data.FilterGroupDTO;
import org.cxbox.meta.data.ScreenDTO;
import org.cxbox.meta.data.ScreenNavigation;
import org.cxbox.meta.data.ViewDTO;
import org.cxbox.meta.data.WidgetDTO;
import org.cxbox.meta.entity.BcProperties;
import org.cxbox.meta.entity.FilterGroup;
import org.cxbox.meta.metahotreload.dto.ScreenSourceDto;
import org.cxbox.meta.ui.model.json.WidgetOptions;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ScreenMapper {
    private final AtomicLong screenSeq = new AtomicLong(0L);
    private final AtomicInteger menuItemSeq = new AtomicInteger();
    private final BcRegistry bcRegistry;
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;

    public ScreenDTO map(ScreenSourceDto dto, Map<String, ViewDTO> viewNameToView, Map<String, BcProperties> bcProps, Map<String, List<FilterGroup>> filterGroupsAll) {
        ArrayList<String> currentScreenViewNames = new ArrayList<String>();
        ScreenDTO screenDTO = new ScreenDTO().setName(dto.getName()).setTitle(dto.getTitle()).setPrimary(dto.getPrimaryViewName()).setNavigation(new ScreenNavigation().setMenu(dto.getNavigation().getMenu().stream().map(e -> this.mapToAndPopulateViewNames((ScreenSourceDto.ScreenNavigationSourceDto.MenuItemSourceDto)e, (List<String>)currentScreenViewNames)).toList())).setViews(ScreenMapper.intersection(viewNameToView, currentScreenViewNames).toList()).setBo(this.getBusinessObject(ScreenMapper.intersection(viewNameToView, currentScreenViewNames).collect(Collectors.toMap(ViewDTO::getName, e -> e)), bcProps, filterGroupsAll)).setPrimaries(org.cxbox.meta.metahotreload.util.JsonUtils.serializeOrElseNull(this.objectMapper, dto.getPrimaryViews()));
        screenDTO.setId(String.valueOf(this.screenSeq.getAndIncrement()));
        return screenDTO;
    }

    private static Stream<ViewDTO> intersection(Map<String, ViewDTO> viewNameToView, List<String> screenViewsNames) {
        return screenViewsNames.stream().map(e -> viewNameToView.getOrDefault(e, null)).filter(Objects::nonNull);
    }

    private BusinessObjectDTO getBusinessObject(Map<String, ViewDTO> viewDTOs, Map<String, BcProperties> bcProps, Map<String, List<FilterGroup>> filterGroupsAll) {
        BusinessObjectDTO businessObjectDTO = new BusinessObjectDTO(viewDTOs.values().stream().map(ViewDTO::getWidgets).flatMap(Collection::stream).filter(widgetDTO -> Objects.nonNull(widgetDTO.getBcName())).map(this::getWidgetBc).flatMap(Collection::stream).peek(this::setBcId).distinct().sorted(Comparator.comparing(BusinessComponentDTO::getUrl)).collect(Collectors.toList()));
        this.setBcParameters(businessObjectDTO, bcProps);
        this.setFilterGroups(businessObjectDTO, filterGroupsAll);
        return businessObjectDTO;
    }

    public Map<String, List<FilterGroup>> getFilterGroups(BusinessObjectDTO boDto, Map<String, List<FilterGroup>> filterGroupsAll) {
        HashMap<String, List<FilterGroup>> result = new HashMap<String, List<FilterGroup>>(boDto.getBc().size());
        boDto.getBc().forEach(bc -> result.put(bc.getName(), (List)filterGroupsAll.get(bc.getName())));
        return result;
    }

    private void setFilterGroups(BusinessObjectDTO boDto, Map<String, List<FilterGroup>> filterGroupsAll) {
        Map<String, List<FilterGroup>> filterGroupMap = this.getFilterGroups(boDto, filterGroupsAll);
        boDto.getBc().forEach(dto -> {
            List filterGroups = (List)filterGroupMap.get(dto.getName());
            if (filterGroups != null && !filterGroups.isEmpty()) {
                ArrayList<FilterGroupDTO> result = new ArrayList<FilterGroupDTO>();
                filterGroups.forEach(fg -> {
                    FilterGroupDTO filterGroupDTO = this.toFilterGroupDTO((FilterGroup)((Object)((Object)fg)));
                    result.add(filterGroupDTO);
                });
                dto.setFilterGroups(result);
            }
        });
    }

    public FilterGroupDTO toFilterGroupDTO(FilterGroup entity) {
        FilterGroupDTO dto = new FilterGroupDTO().setName(entity.getName()).setFilters(entity.getFilters()).setBc(entity.getBc());
        dto.setId(entity.getId().toString());
        return dto;
    }

    private void setBcParameters(BusinessObjectDTO boDto, Map<String, BcProperties> bcProps) {
        Map<String, BcProperties> defaultBcPropertiesMap = this.getStringDefaultBcPropertiesMap(boDto, bcProps);
        boDto.getBc().forEach(dto -> {
            BcDescription bcDescription;
            BcProperties bcProperties = (BcProperties)((Object)((Object)defaultBcPropertiesMap.get(dto.getName())));
            if (bcProperties != null) {
                Optional.ofNullable(bcProperties.getLimit()).ifPresent(dto::setLimit);
                Optional.ofNullable(bcProperties.getReportPeriod()).ifPresent(dto::setReportPeriod);
                Optional.ofNullable(bcProperties.getSort()).ifPresent(dto::setDefaultSort);
                Optional.ofNullable(bcProperties.getFilter()).ifPresent(dto::setDefaultFilter);
                Optional.ofNullable(bcProperties.getDimFilterSpec()).ifPresent(dto::setDimFilterSpec);
            }
            if ((bcDescription = this.bcRegistry.getBcDescription(dto.getName())) != null) {
                Optional.ofNullable(bcDescription.getParentName()).ifPresent(dto::setParentName);
                Optional.ofNullable(bcDescription.isRefresh()).ifPresent(dto::setRefresh);
                Optional.ofNullable(bcDescription.getBindsString()).ifPresent(dto::setBinds);
                Optional.ofNullable(bcDescription.getPageLimit()).ifPresent(dto::setLimit);
            }
        });
    }

    public Map<String, BcProperties> getStringDefaultBcPropertiesMap(BusinessObjectDTO boDto, Map<String, BcProperties> bcProps) {
        HashMap<String, BcProperties> result = new HashMap<String, BcProperties>(boDto.getBc().size());
        boDto.getBc().forEach(bc -> result.put(bc.getName(), (BcProperties)((Object)((Object)bcProps.get(bc.getName())))));
        return result;
    }

    private void setBcId(BusinessComponentDTO dto) {
        BcDescription description = this.bcRegistry.getBcDescription(dto.getName());
        if (description != null) {
            Optional.ofNullable(description.getId()).ifPresent(dto::setId);
        }
    }

    private List<BusinessComponentDTO> getWidgetBc(WidgetDTO widgetDTO) {
        ArrayList<BusinessComponentDTO> result = new ArrayList<BusinessComponentDTO>();
        result.add(new BusinessComponentDTO(widgetDTO));
        Optional.ofNullable(widgetDTO.getOptions()).map(JsonUtils::readTree).filter(JsonNode::isObject).map(options -> (WidgetOptions)JsonUtils.readValue(WidgetOptions.class, (TreeNode)options)).map(WidgetOptions::getHierarchy).ifPresent(list -> list.forEach(item -> {
            String bcName = item.getBcName();
            String url = this.bcRegistry.getUrlFromBc(bcName);
            result.add(new BusinessComponentDTO(new BcSourceBaseDTO(bcName, url)));
        }));
        return result;
    }

    private ScreenNavigation.MenuItem mapToAndPopulateViewNames(ScreenSourceDto.ScreenNavigationSourceDto.MenuItemSourceDto item, List<String> screenViews) {
        ScreenNavigation.MenuItem menuItem;
        if (item.getViewName() != null) {
            ScreenNavigation.SingleView singleView = new ScreenNavigation.SingleView();
            singleView.setViewName(item.getViewName());
            singleView.setHidden(Optional.ofNullable(item.getHidden()).orElse(false));
            singleView.setSeq(this.menuItemSeq.incrementAndGet());
            singleView.setId(String.valueOf(singleView.getSeq()));
            screenViews.add(singleView.getViewName());
            menuItem = singleView;
        } else {
            ScreenNavigation.ViewGroup viewGroup = new ScreenNavigation.ViewGroup();
            viewGroup.setHidden(Optional.ofNullable(item.getHidden()).orElse(false));
            viewGroup.setSeq(this.menuItemSeq.incrementAndGet());
            viewGroup.setId(String.valueOf(viewGroup.getSeq()));
            viewGroup.setDefaultView(item.getDefaultView());
            viewGroup.setTitle(item.getTitle());
            viewGroup.setChild(item.getChild().stream().map(e -> this.mapToAndPopulateViewNames((ScreenSourceDto.ScreenNavigationSourceDto.MenuItemSourceDto)e, screenViews)).toList());
            menuItem = viewGroup;
        }
        return menuItem;
    }

    @ConstructorProperties(value={"bcRegistry", "objectMapper"})
    @Generated
    public ScreenMapper(BcRegistry bcRegistry, @Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        this.bcRegistry = bcRegistry;
        this.objectMapper = objectMapper;
    }
}

