/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.mapper;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.SerializationUtils;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.IUser;
import org.cxbox.core.service.ResponsibilitiesService;
import org.cxbox.meta.data.ScreenDTO;
import org.cxbox.meta.data.ViewDTO;
import org.cxbox.meta.metahotreload.mapper.MetaProvider;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class UserMetaProvider {
    private final MetaProvider metaProvider;
    private final ResponsibilitiesService responsibilitiesService;

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"userCache"}, key="{#root.methodName}")
    public Map<String, ScreenDTO> getScreens(IUser<Long> user, LOV userRole) {
        Map<String, ScreenDTO> allScreens = this.metaProvider.getAllScreens();
        Map allUserScreens = (Map)((Object)SerializationUtils.clone((Serializable)((HashMap)allScreens)));
        Map userViewToReadOnlyFlg = this.responsibilitiesService.getListRespByUser(user, userRole);
        allUserScreens.values().forEach(s -> {
            List<ViewDTO> userViews = s.getViews().stream().filter(v -> v.getName() != null && userViewToReadOnlyFlg.containsKey(v.getName())).toList();
            s.setViews(userViews);
        });
        return allUserScreens;
    }

    @ConstructorProperties(value={"metaProvider", "responsibilitiesService"})
    @Generated
    public UserMetaProvider(MetaProvider metaProvider, ResponsibilitiesService responsibilitiesService) {
        this.metaProvider = metaProvider;
        this.responsibilitiesService = responsibilitiesService;
    }
}

