/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.meta.data.WidgetDTO;
import org.cxbox.meta.metahotreload.dto.ViewSourceDTO;
import org.cxbox.meta.metahotreload.dto.WidgetSourceDTO;
import org.cxbox.meta.metahotreload.util.JsonUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class WidgetMapper {
    private final AtomicInteger widgetSeq = new AtomicInteger(0);
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;
    private final BcRegistry bcRegistry;

    public WidgetDTO map(WidgetSourceDTO dto, ViewSourceDTO.ViewWidgetSourceDTO viewWidget) {
        WidgetDTO widgetDTO = new WidgetDTO().setName(dto.getName()).setType(dto.getType()).setUrl(this.bcRegistry.getUrlFromBc(dto.getBc())).setBcName(dto.getBc()).setTitle(dto.getTitle()).setFields(JsonUtils.serializeOrElseEmptyArr(this.objectMapper, dto.getFields())).setOptions(JsonUtils.serializeOrElseEmptyArr(this.objectMapper, dto.getOptions())).setPivotFields(JsonUtils.serializeOrElseNull(this.objectMapper, dto.getPivotFields())).setAxisFields(JsonUtils.serializeOrElseEmptyArr(this.objectMapper, dto.getAxisFields())).setShowCondition(JsonUtils.serializeOrElseEmptyArr(this.objectMapper, dto.getShowCondition())).setChart(JsonUtils.serializeOrElseEmptyArr(this.objectMapper, dto.getChart())).setGraph(JsonUtils.serializeOrElseNull(this.objectMapper, dto.getGraph()));
        widgetDTO.setWidgetId(this.widgetSeq.getAndIncrement());
        widgetDTO.setPosition(viewWidget.getPosition()).setDescriptionTitle(viewWidget.getDescriptionTitle()).setDescription(null).setSnippet(viewWidget.getSnippet()).setLimit(Optional.ofNullable(viewWidget.getPageLimit()).orElse(0L)).setGridWidth(Optional.ofNullable(viewWidget.getGridWidth()).orElse(1L)).setGridBreak(Optional.ofNullable(viewWidget.getGridBreak()).orElse(0L)).setHide(Optional.ofNullable(viewWidget.getHideByDefault()).orElse(false)).setShowExportStamp(Optional.ofNullable(viewWidget.getShowExportStamp()).orElse(false));
        return widgetDTO;
    }

    @ConstructorProperties(value={"objectMapper", "bcRegistry"})
    @Generated
    public WidgetMapper(@Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper, BcRegistry bcRegistry) {
        this.objectMapper = objectMapper;
        this.bcRegistry = bcRegistry;
    }
}

