/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.repository;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.IUser;
import org.cxbox.meta.entity.Bc;
import org.cxbox.meta.entity.BcProperties;
import org.cxbox.meta.entity.BcProperties_;
import org.cxbox.meta.entity.FilterGroup;
import org.cxbox.meta.entity.FilterGroup_;
import org.cxbox.meta.entity.Responsibilities;
import org.cxbox.meta.entity.Responsibilities_;
import org.cxbox.meta.entity.Screen;
import org.cxbox.meta.entity.Screen_;
import org.cxbox.meta.entity.View;
import org.cxbox.meta.entity.ViewWidgets;
import org.cxbox.meta.entity.ViewWidgets_;
import org.cxbox.meta.entity.View_;
import org.cxbox.meta.entity.Widget;
import org.cxbox.meta.entity.Widget_;
import org.cxbox.meta.navigation.NavigationGroup;
import org.cxbox.meta.navigation.NavigationGroup_;
import org.cxbox.meta.navigation.NavigationView;
import org.cxbox.meta.navigation.NavigationView_;
import org.cxbox.model.core.dao.JpaDao;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class MetaRepository {
    private final JpaDao jpaDao;

    public void saveScreen(Screen screen) {
        this.jpaDao.save((Object)screen);
    }

    public void saveView(View view) {
        this.jpaDao.save((Object)view);
    }

    public void saveViewWidget(ViewWidgets viewWidget) {
        this.jpaDao.save((Object)viewWidget);
    }

    public void saveAllWidgets(Map<String, Widget> nameToWidget) {
        nameToWidget.forEach((name, widget) -> this.jpaDao.save((Object)widget));
    }

    public void saveBc(Bc bc) {
        this.jpaDao.save((Object)bc);
    }

    public void saveNavigationGroup(NavigationGroup navigationGroup) {
        this.jpaDao.save((Object)navigationGroup);
    }

    public void saveNavigationView(NavigationView navigationView) {
        this.jpaDao.save((Object)navigationView);
    }

    public void deleteAndSaveResponsibilities(List<Responsibilities> responsibilities) {
        this.jpaDao.delete(Responsibilities.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        this.jpaDao.saveAll(responsibilities);
    }

    public List<NavigationView> getNavigationViews() {
        return this.jpaDao.getList(NavigationView.class);
    }

    public void deleteAllMeta() {
        this.jpaDao.delete(NavigationView.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        this.jpaDao.delete(NavigationGroup.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        this.jpaDao.delete(Screen.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        this.jpaDao.delete(ViewWidgets.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        this.jpaDao.delete(View.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        this.jpaDao.delete(Widget.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        this.jpaDao.delete(Bc.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
    }

    public Screen getScreenByName(String name) {
        return (Screen)((Object)this.jpaDao.getSingleResultOrNull(Screen.class, (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(Screen_.name), (Object)name)));
    }

    public List<NavigationView> getViewByScreenAndResponsibilities(String screenName, boolean getAll, Set<String> responsibilities) {
        return this.jpaDao.getList(NavigationView.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(NavigationView_.screenName), (Object)screenName), cb.equal((Expression)root.get(NavigationView_.typeCd), (Object)CoreDictionaries.ViewGroupType.NAVIGATION), getAll ? cb.and(new Predicate[0]) : root.get(NavigationView_.viewName).in((Collection)responsibilities)}));
    }

    public Widget getWidgetById(Long widgetId) {
        return (Widget)this.jpaDao.findById(Widget.class, widgetId);
    }

    public List<Long> getWidgetByViewName(String viewName) {
        return this.jpaDao.getList(ViewWidgets.class, Long.class, (root, cb) -> root.get(ViewWidgets_.widget).get(Widget_.id), (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(ViewWidgets_.viewName), (Object)viewName));
    }

    public List<Long> getBcWidgets(String bc) {
        return this.jpaDao.getList(Widget.class, Long.class, (root, cb) -> root.get(Widget_.id), (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(Widget_.bc), (Object)bc));
    }

    public List<String> getWidget(Long widgetId) {
        return this.jpaDao.getList(ViewWidgets.class, String.class, (root, cb) -> root.get(ViewWidgets_.viewName), (Specification & Serializable)(root, query, cb) -> {
            query.distinct(true);
            return cb.equal((Expression)root.get(ViewWidgets_.widget).get(Widget_.id), (Object)widgetId);
        });
    }

    public List<NavigationGroup> getScreenNavigationGroups(Screen screen) {
        return this.jpaDao.getList(NavigationGroup.class, (Specification & Serializable)(root, query, cb) -> {
            query.orderBy(new Order[]{cb.asc((Expression)root.get(NavigationGroup_.seq))});
            return cb.and((Expression)cb.equal((Expression)root.get(NavigationGroup_.screenName), (Object)screen.getName()), (Expression)cb.equal((Expression)root.get(NavigationGroup_.typeCd), (Object)CoreDictionaries.ViewGroupType.NAVIGATION));
        });
    }

    public List<NavigationView> getScreenViews(Screen screen) {
        return this.jpaDao.getList(NavigationView.class, (Specification & Serializable)(root, query, cb) -> {
            query.orderBy(new Order[]{cb.asc((Expression)root.get(NavigationView_.seq))});
            return cb.and((Expression)cb.equal((Expression)root.get(NavigationView_.screenName), (Object)screen.getName()), (Expression)cb.equal((Expression)root.get(NavigationView_.typeCd), (Object)CoreDictionaries.ViewGroupType.NAVIGATION));
        });
    }

    public Map<String, List<ViewWidgets>> getWidgets() {
        return this.jpaDao.getList(ViewWidgets.class, (Specification & Serializable)(root, cq, cb) -> {
            root.fetch(ViewWidgets_.widget);
            return cb.isNotNull((Expression)root.get(ViewWidgets_.viewName));
        }).stream().collect(Collectors.groupingBy(ViewWidgets::getViewName));
    }

    public Map<String, View> getViews() {
        return this.jpaDao.getList(View.class, (Specification & Serializable)(root, cq, cb) -> cb.isNotNull((Expression)root.get(View_.name))).stream().collect(Collectors.toMap(View::getName, Function.identity()));
    }

    public Map<String, BcProperties> getBcProperties() {
        return this.jpaDao.getList(BcProperties.class, (Specification & Serializable)(root, cq, cb) -> cb.isNotNull((Expression)root.get(BcProperties_.bc))).stream().collect(Collectors.toMap(BcProperties::getBc, Function.identity()));
    }

    public Map<String, List<FilterGroup>> getFilterGroups() {
        return this.jpaDao.getList(FilterGroup.class, (Specification & Serializable)(root, cq, cb) -> cb.isNotNull((Expression)root.get(FilterGroup_.bc))).stream().collect(Collectors.groupingBy(FilterGroup::getBc));
    }

    public List<Responsibilities> getListByUserList(IUser<Long> user, LOV userRole, Responsibilities.ResponsibilityType responsibilityType) {
        return this.jpaDao.getList(Responsibilities.class, (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(Responsibilities_.departmentId), user.getDepartmentId()), cb.equal((Expression)root.get(Responsibilities_.internalRoleCD), (Object)userRole), cb.equal((Expression)root.get(Responsibilities_.responsibilityType), (Object)responsibilityType)}));
    }

    @ConstructorProperties(value={"jpaDao"})
    @Generated
    public MetaRepository(JpaDao jpaDao) {
        this.jpaDao = jpaDao;
    }
}

