/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.service;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.MetaHotReloadService;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.InternalAuthorizationService;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.meta.entity.Responsibilities;
import org.cxbox.meta.entity.Widget;
import org.cxbox.meta.metahotreload.conf.properties.MetaConfigurationProperties;
import org.cxbox.meta.metahotreload.dto.BcSourceDTO;
import org.cxbox.meta.metahotreload.dto.ScreenSourceDto;
import org.cxbox.meta.metahotreload.dto.ViewSourceDTO;
import org.cxbox.meta.metahotreload.dto.WidgetSourceDTO;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.cxbox.meta.metahotreload.service.BcUtil;
import org.cxbox.meta.metahotreload.service.MetaResourceReaderService;
import org.cxbox.meta.metahotreload.service.ScreenAndNavigationGroupAndNavigationViewUtil;
import org.cxbox.meta.metahotreload.service.ViewAndViewWidgetUtil;
import org.cxbox.meta.metahotreload.service.WidgetUtil;
import org.cxbox.meta.navigation.NavigationView;

public class MetaHotReloadServiceImpl
implements MetaHotReloadService {
    protected final MetaConfigurationProperties config;
    protected final MetaResourceReaderService metaResourceReaderService;
    protected final InternalAuthorizationService authzService;
    protected final TransactionService txService;
    protected final MetaRepository metaRepository;
    protected final WidgetUtil widgetUtil;
    protected final ViewAndViewWidgetUtil viewAndViewWidgetUtil;
    protected final ScreenAndNavigationGroupAndNavigationViewUtil screenAndNavigationGroupAndNavigationViewUtil;
    protected final BcUtil bcUtil;

    public void loadMeta() {
        List<BcSourceDTO> bcDtos = this.metaResourceReaderService.getBcs();
        List<ScreenSourceDto> screenDtos = this.metaResourceReaderService.getScreens();
        List<WidgetSourceDTO> widgetDtos = this.metaResourceReaderService.getWidgets();
        List<ViewSourceDTO> viewDtos = this.metaResourceReaderService.getViews();
        this.authzService.loginAs(this.authzService.createAuthentication(InternalAuthorizationService.VANILLA));
        this.txService.invokeInTx(() -> {
            this.loadMetaPreProcess(widgetDtos, viewDtos, screenDtos);
            this.metaRepository.deleteAllMeta();
            this.bcUtil.process(bcDtos);
            Map<String, Widget> nameToWidget = this.widgetUtil.process(widgetDtos);
            this.viewAndViewWidgetUtil.process(viewDtos, nameToWidget);
            this.screenAndNavigationGroupAndNavigationViewUtil.process(screenDtos);
            this.responsibilitiesProcess(screenDtos, viewDtos);
            this.loadMetaAfterProcess();
            return null;
        });
    }

    private void responsibilitiesProcess(List<ScreenSourceDto> screenDtos, List<ViewSourceDTO> viewDtos) {
        if (this.config.isViewAllowedRolesEnabled()) {
            Map<String, String> viewToScreenMap = this.metaRepository.getNavigationViews().stream().collect(Collectors.toMap(NavigationView::getViewName, NavigationView::getScreenName));
            ArrayList<Responsibilities> responsibilities = new ArrayList<Responsibilities>();
            long defaultDepartmentId = 0L;
            viewDtos.forEach(view -> view.getRolesAllowed().forEach(role -> responsibilities.add(new Responsibilities().setResponsibilityType(Responsibilities.ResponsibilityType.VIEW).setInternalRoleCD(new LOV(role)).setView(view.getName()).setDepartmentId(defaultDepartmentId))));
            Map<String, ScreenSourceDto> screenNameToScreen = screenDtos.stream().collect(Collectors.toMap(ScreenSourceDto::getName, sd -> sd));
            HashMap rolesToScreens = new HashMap();
            viewDtos.forEach(v -> {
                if (viewToScreenMap.containsKey(v.getName())) {
                    String screenName = (String)viewToScreenMap.get(v.getName());
                    v.getRolesAllowed().forEach(role -> {
                        if (!rolesToScreens.containsKey(role)) {
                            rolesToScreens.put(role, new HashSet());
                        }
                        ((Set)rolesToScreens.get(role)).add((ScreenSourceDto)screenNameToScreen.get(screenName));
                    });
                }
            });
            for (Map.Entry entry : rolesToScreens.entrySet()) {
                String role = (String)entry.getKey();
                Set screens = (Set)entry.getValue();
                responsibilities.add(new Responsibilities().setResponsibilityType(Responsibilities.ResponsibilityType.SCREEN).setInternalRoleCD(new LOV(role)).setScreens(this.mapToScreens(screenNameToScreen, screens)).setDepartmentId(defaultDepartmentId));
            }
            this.metaRepository.deleteAndSaveResponsibilities(responsibilities);
        }
    }

    @NonNull
    private String mapToScreens(@NonNull Map<String, ScreenSourceDto> screenNameToScreen, @NonNull Set<ScreenSourceDto> screens) {
        if (screenNameToScreen == null) {
            throw new NullPointerException("screenNameToScreen is marked non-null but is null");
        }
        if (screens == null) {
            throw new NullPointerException("screens is marked non-null but is null");
        }
        StringJoiner joiner = new StringJoiner(",");
        List orderedScreens = screens.stream().sorted(Comparator.comparing(ScreenSourceDto::getOrder).thenComparing(ScreenSourceDto::getName)).collect(Collectors.toList());
        for (int i = 0; i < orderedScreens.size(); ++i) {
            ScreenSourceDto screen = (ScreenSourceDto)orderedScreens.get(i);
            String s = "  {\n    \"id\": \"id" + i + "\",\n    \"name\": \"" + screen.getName() + "\",\n    \"text\": \"" + screen.getTitle() + "\",\n    \"url\": \"/screen/" + screen.getName() + "\",\n    \"icon\": \"" + screen.getIcon() + "\"\n  }";
            joiner.add(s);
        }
        String collect = joiner.toString();
        return "[\n" + collect + "\n]";
    }

    protected void loadMetaPreProcess(List<WidgetSourceDTO> widgetDtos, List<ViewSourceDTO> viewDtos, List<ScreenSourceDto> screenDtos) {
    }

    protected void loadMetaAfterProcess() {
    }

    @ConstructorProperties(value={"config", "metaResourceReaderService", "authzService", "txService", "metaRepository", "widgetUtil", "viewAndViewWidgetUtil", "screenAndNavigationGroupAndNavigationViewUtil", "bcUtil"})
    @Generated
    public MetaHotReloadServiceImpl(MetaConfigurationProperties config, MetaResourceReaderService metaResourceReaderService, InternalAuthorizationService authzService, TransactionService txService, MetaRepository metaRepository, WidgetUtil widgetUtil, ViewAndViewWidgetUtil viewAndViewWidgetUtil, ScreenAndNavigationGroupAndNavigationViewUtil screenAndNavigationGroupAndNavigationViewUtil, BcUtil bcUtil) {
        this.config = config;
        this.metaResourceReaderService = metaResourceReaderService;
        this.authzService = authzService;
        this.txService = txService;
        this.metaRepository = metaRepository;
        this.widgetUtil = widgetUtil;
        this.viewAndViewWidgetUtil = viewAndViewWidgetUtil;
        this.screenAndNavigationGroupAndNavigationViewUtil = screenAndNavigationGroupAndNavigationViewUtil;
        this.bcUtil = bcUtil;
    }
}

