/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.meta.entity.Screen;
import org.cxbox.meta.metahotreload.dto.ScreenSourceDto;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.cxbox.meta.metahotreload.util.JsonUtils;
import org.cxbox.meta.navigation.NavigationGroup;
import org.cxbox.meta.navigation.NavigationView;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ScreenAndNavigationGroupAndNavigationViewUtil {
    private final MetaRepository metaRepository;
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objMapper;

    public void process(@NonNull List<ScreenSourceDto> screenDtos) {
        if (screenDtos == null) {
            throw new NullPointerException("screenDtos is marked non-null but is null");
        }
        screenDtos.forEach(scr -> {
            Screen screen = ScreenAndNavigationGroupAndNavigationViewUtil.mapToScreen(this.objMapper, scr);
            this.metaRepository.saveScreen(screen);
            if (scr.getNavigation() != null && scr.getNavigation().getMenu() != null) {
                AtomicInteger seq = new AtomicInteger(0);
                scr.getNavigation().getMenu().forEach(menu -> ScreenAndNavigationGroupAndNavigationViewUtil.dfs(scr.getName(), seq, null, menu, this.metaRepository));
            }
        });
    }

    @NonNull
    private static Screen mapToScreen(@NonNull ObjectMapper objectMapper, @NonNull ScreenSourceDto screenSourceDto) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (screenSourceDto == null) {
            throw new NullPointerException("screenSourceDto is marked non-null but is null");
        }
        return new Screen().setName(screenSourceDto.getName()).setTitle(screenSourceDto.getTitle()).setPrimary(screenSourceDto.getPrimaryViewName()).setPrimaries(JsonUtils.serializeOrElseNull(objectMapper, screenSourceDto.getPrimaryViews()));
    }

    private static void dfs(@NonNull String screenName, @NonNull AtomicInteger seq, @Nullable NavigationGroup parent, @NonNull ScreenSourceDto.ScreenNavigationSourceDto.MenuItemSourceDto menuDto, @NonNull MetaRepository metaRepository) {
        if (screenName == null) {
            throw new NullPointerException("screenName is marked non-null but is null");
        }
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (menuDto == null) {
            throw new NullPointerException("menuDto is marked non-null but is null");
        }
        if (metaRepository == null) {
            throw new NullPointerException("metaRepository is marked non-null but is null");
        }
        if (menuDto.getChild() != null && !menuDto.getChild().isEmpty()) {
            NavigationGroup navigationGroup = ScreenAndNavigationGroupAndNavigationViewUtil.mapToNavigationGroup(screenName, seq.get(), parent, menuDto);
            metaRepository.saveNavigationGroup(navigationGroup);
            seq.incrementAndGet();
            menuDto.getChild().forEach(child -> ScreenAndNavigationGroupAndNavigationViewUtil.dfs(screenName, seq, navigationGroup, child, metaRepository));
        } else {
            NavigationView navigationView = ScreenAndNavigationGroupAndNavigationViewUtil.mapToNavigationView(screenName, seq.get(), parent, menuDto);
            metaRepository.saveNavigationView(navigationView);
            seq.incrementAndGet();
        }
    }

    @NonNull
    private static NavigationGroup mapToNavigationGroup(@NonNull String screenName, int seq, @Nullable NavigationGroup parentNavigationGroup, @NonNull ScreenSourceDto.ScreenNavigationSourceDto.MenuItemSourceDto menu) {
        if (screenName == null) {
            throw new NullPointerException("screenName is marked non-null but is null");
        }
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        return new NavigationGroup().setId(UUID.randomUUID().toString().replace("-", "")).setTypeCd(CoreDictionaries.ViewGroupType.NAVIGATION).setScreenName(screenName).setTitle(menu.getTitle()).setParent(parentNavigationGroup).setSeq(seq).setDescription(null).setDefaultView(Optional.ofNullable(menu.getDefaultView()).orElse(menu.getViewName())).setHidden(Optional.ofNullable(menu.getHidden()).orElse(false));
    }

    @NonNull
    private static NavigationView mapToNavigationView(@NonNull String screenName, int seq, @Nullable NavigationGroup parentGroup, @NonNull ScreenSourceDto.ScreenNavigationSourceDto.MenuItemSourceDto menuDto) {
        if (screenName == null) {
            throw new NullPointerException("screenName is marked non-null but is null");
        }
        if (menuDto == null) {
            throw new NullPointerException("menuDto is marked non-null but is null");
        }
        return new NavigationView().setId(UUID.randomUUID().toString().replace("-", "")).setViewName(menuDto.getViewName()).setDescription(null).setViewName(Optional.ofNullable(menuDto.getViewName()).orElse(menuDto.getDefaultView())).setHidden(Optional.ofNullable(menuDto.getHidden()).orElse(false)).setSeq(seq).setTypeCd(CoreDictionaries.ViewGroupType.NAVIGATION).setScreenName(screenName).setParentGroup(parentGroup);
    }

    @ConstructorProperties(value={"metaRepository", "objMapper"})
    @Generated
    public ScreenAndNavigationGroupAndNavigationViewUtil(MetaRepository metaRepository, @Qualifier(value="cxboxObjectMapper") ObjectMapper objMapper) {
        this.metaRepository = metaRepository;
        this.objMapper = objMapper;
    }
}

