/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.cxbox.meta.entity.View;
import org.cxbox.meta.entity.ViewWidgets;
import org.cxbox.meta.entity.ViewWidgetsPK;
import org.cxbox.meta.entity.Widget;
import org.cxbox.meta.metahotreload.conf.properties.MetaConfigurationProperties;
import org.cxbox.meta.metahotreload.dto.ViewSourceDTO;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.cxbox.meta.metahotreload.util.JsonUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class ViewAndViewWidgetUtil {
    private final MetaRepository metaRepository;
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objMapper;
    final ApplicationContext applicationContext;
    final MetaConfigurationProperties config;

    public void process(@NonNull List<ViewSourceDTO> viewDtos, @NonNull Map<String, Widget> nameToWidget) {
        if (viewDtos == null) {
            throw new NullPointerException("viewDtos is marked non-null but is null");
        }
        if (nameToWidget == null) {
            throw new NullPointerException("nameToWidget is marked non-null but is null");
        }
        viewDtos.forEach(viewDto -> {
            View view = ViewAndViewWidgetUtil.mapToView(this.objMapper, viewDto);
            this.metaRepository.saveView(view);
            if (viewDto.getWidgets() != null) {
                viewDto.getWidgets().forEach(viewWidgetDto -> {
                    Widget widget = (Widget)((Object)((Object)((Object)nameToWidget.get(viewWidgetDto.getWidgetNaturalKey()))));
                    String viewName = viewDto.getName();
                    ViewWidgets viewWidget = this.mapToViewWidget(viewName, widget, (ViewSourceDTO.ViewWidgetSourceDTO)viewWidgetDto);
                    this.metaRepository.saveViewWidget(viewWidget);
                });
            }
        });
    }

    @NonNull
    private static View mapToView(@NonNull ObjectMapper objectMapper, @NonNull ViewSourceDTO dto) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (dto == null) {
            throw new NullPointerException("dto is marked non-null but is null");
        }
        return new View().setName(dto.getName()).setTemplate(dto.getTemplate()).setTitle(dto.getTitle()).setUrl(dto.getUrl()).setCustomizable(Optional.ofNullable(dto.getCustomizable()).orElse(false)).setEditable(Optional.ofNullable(dto.getEditable()).orElse(false)).setIgnoreHistory(Optional.ofNullable(dto.getIgnoreHistory()).orElse(false)).setOptions(JsonUtils.serializeOrElseEmptyArr(objectMapper, dto.getOptions()));
    }

    @NonNull
    private ViewWidgets mapToViewWidget(@NonNull String viewName, @NonNull Widget widget, @NonNull ViewSourceDTO.ViewWidgetSourceDTO dto) {
        if (viewName == null) {
            throw new NullPointerException("viewName is marked non-null but is null");
        }
        if (widget == null) {
            throw new NullPointerException("widget is marked non-null but is null");
        }
        if (dto == null) {
            throw new NullPointerException("dto is marked non-null but is null");
        }
        return new ViewWidgets().setPk(new ViewWidgetsPK().setViewName(viewName).setWidgetId(widget.getId())).setViewName(viewName).setWidget(widget).setPositon(dto.getPosition()).setDescriptionTitle(dto.getDescriptionTitle()).setDescription(this.getWidgetDescription(dto)).setSnippet(dto.getSnippet()).setLimit(dto.getPageLimit()).setGridWidth(Optional.ofNullable(dto.getGridWidth()).orElse(1L)).setGridBreak(Optional.ofNullable(dto.getGridBreak()).orElse(0L)).setHide(Optional.ofNullable(dto.getHideByDefault()).orElse(false)).setShowExportStamp(Optional.ofNullable(dto.getShowExportStamp()).orElse(false));
    }

    private String getWidgetDescription(ViewSourceDTO.ViewWidgetSourceDTO dto) {
        if (dto.getDescription() != null && !Objects.equals(dto.getDescription(), "")) {
            return dto.getDescription();
        }
        if (dto.getDescriptionFile() != null && !Objects.equals(dto.getDescriptionFile(), "")) {
            Resource resource = this.applicationContext.getResource(this.config.getDirectory() + dto.getDescriptionFile());
            return IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    @ConstructorProperties(value={"metaRepository", "objMapper", "applicationContext", "config"})
    @Generated
    public ViewAndViewWidgetUtil(MetaRepository metaRepository, @Qualifier(value="cxboxObjectMapper") ObjectMapper objMapper, ApplicationContext applicationContext, MetaConfigurationProperties config) {
        this.metaRepository = metaRepository;
        this.objMapper = objMapper;
        this.applicationContext = applicationContext;
        this.config = config;
    }
}

