/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.cxbox.meta.entity.Widget;
import org.cxbox.meta.metahotreload.dto.WidgetSourceDTO;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.cxbox.meta.metahotreload.util.JsonUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class WidgetUtil {
    private final MetaRepository metaRepository;
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objMapper;

    @NonNull
    public Map<String, Widget> process(@NonNull List<WidgetSourceDTO> widgetDtos) {
        if (widgetDtos == null) {
            throw new NullPointerException("widgetDtos is marked non-null but is null");
        }
        Map<String, Widget> nameToWidget = widgetDtos.stream().map(widgetDto -> Pair.of((Object)widgetDto.getWidgetNaturalKey(), (Object)((Object)WidgetUtil.mapToWidget(this.objMapper, widgetDto)))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        this.metaRepository.saveAllWidgets(nameToWidget);
        return nameToWidget;
    }

    @NonNull
    private static Widget mapToWidget(@NonNull ObjectMapper objectMapper, @NonNull WidgetSourceDTO dto) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (dto == null) {
            throw new NullPointerException("dto is marked non-null but is null");
        }
        return new Widget().setName(dto.getName()).setType(dto.getType()).setBc(dto.getBc()).setTitle(dto.getTitle()).setFields(JsonUtils.serializeOrElseEmptyArr(objectMapper, dto.getFields())).setOptions(JsonUtils.serializeOrElseEmptyArr(objectMapper, dto.getOptions())).setPivotFields(JsonUtils.serializeOrElseNull(objectMapper, dto.getPivotFields())).setAxisFields(JsonUtils.serializeOrElseEmptyArr(objectMapper, dto.getAxisFields())).setShowCondition(JsonUtils.serializeOrElseEmptyArr(objectMapper, dto.getShowCondition())).setChart(JsonUtils.serializeOrElseEmptyArr(objectMapper, dto.getChart())).setGraph(JsonUtils.serializeOrElseNull(objectMapper, dto.getGraph()));
    }

    @ConstructorProperties(value={"metaRepository", "objMapper"})
    @Generated
    public WidgetUtil(MetaRepository metaRepository, @Qualifier(value="cxboxObjectMapper") ObjectMapper objMapper) {
        this.metaRepository = metaRepository;
        this.objMapper = objMapper;
    }
}

