/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.ui.field;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cxbox.api.util.i18n.LocalizationFormatter;
import org.cxbox.core.util.JuelUtils;
import org.cxbox.meta.entity.Widget;
import org.cxbox.meta.ui.field.FieldExtractor;
import org.cxbox.meta.ui.field.link.LinkFieldExtractor;
import org.cxbox.meta.ui.model.BcField;
import org.cxbox.meta.ui.model.MultivalueField;
import org.cxbox.meta.ui.model.PickListField;
import org.cxbox.meta.ui.model.json.field.FieldMeta;
import org.cxbox.meta.ui.model.json.field.subtypes.MultivalueFieldMeta;
import org.cxbox.meta.ui.model.json.field.subtypes.PickListFieldMeta;

public abstract class BaseFieldExtractor
implements FieldExtractor {
    private final LinkFieldExtractor linkFieldExtractor;

    protected BaseFieldExtractor(LinkFieldExtractor linkFieldExtractor) {
        this.linkFieldExtractor = linkFieldExtractor;
    }

    protected Set<BcField> extract(Widget widget, FieldMeta fieldMeta) {
        HashSet<BcField> widgetFields = new HashSet<BcField>();
        HashSet<BcField> pickListFields = new HashSet<BcField>();
        if (fieldMeta instanceof FieldMeta.FieldContainer) {
            FieldMeta.FieldContainer fieldContainer = (FieldMeta.FieldContainer)((Object)fieldMeta);
            for (FieldMeta child : fieldContainer.getChildren()) {
                widgetFields.addAll(this.extract(widget, child));
            }
        }
        if (fieldMeta instanceof FieldMeta.FieldMetaBase) {
            FieldMeta.FieldMetaBase fieldMetaBase = (FieldMeta.FieldMetaBase)fieldMeta;
            for (PickListField pickList : this.getPickLists(fieldMetaBase)) {
                if (pickList.getPickMap() == null) continue;
                for (Map.Entry<String, String> entry : pickList.getPickMap().entrySet()) {
                    widgetFields.add(new BcField(widget.getBc(), entry.getKey()).putAttribute(BcField.Attribute.WIDGET_ID, widget.getId()));
                    pickListFields.add(new BcField(pickList.getPickListBc(), entry.getValue()).putAttribute(BcField.Attribute.WIDGET_ID, widget.getId()).putAttribute(BcField.Attribute.PARENT_BC, widget.getBc()).putAttribute(BcField.Attribute.PARENT_FIELD, entry.getKey()));
                }
            }
            widgetFields.addAll(this.extractFieldsFromMultiValue(widget, this.getMultivalueField(fieldMetaBase)));
            widgetFields.addAll(this.extractFieldsFromTitle(widget, LocalizationFormatter.i18n((String)fieldMetaBase.getTitle())));
            widgetFields.addAll(this.linkFieldExtractor.extract(widget, fieldMetaBase));
            if (fieldMetaBase.getMultisource() != null) {
                for (FieldMeta.FieldMetaBase.MultiSourceInfo multiSourceInfo : fieldMetaBase.getMultisource()) {
                    widgetFields.add(new BcField(widget.getBc(), multiSourceInfo.getKey()).putAttribute(BcField.Attribute.WIDGET_ID, widget.getId()));
                }
            }
            BcField widgetField = new BcField(widget.getBc(), fieldMetaBase.getKey()).putAttribute(BcField.Attribute.WIDGET_ID, widget.getId()).putAttribute(BcField.Attribute.TYPE, fieldMetaBase.getType()).putAttribute(BcField.Attribute.ICON_TYPE_KEY, fieldMetaBase.getIconTypeKey()).putAttribute(BcField.Attribute.HINT_KEY, fieldMetaBase.getHintKey()).putAttribute(BcField.Attribute.PICK_LIST_FIELDS, pickListFields);
            widgetFields.remove(widgetField);
            widgetFields.add(widgetField);
        }
        return widgetFields;
    }

    private List<BcField> extractFieldsFromMultiValue(Widget widget, MultivalueField multivalueField) {
        ArrayList<BcField> result = new ArrayList<BcField>();
        if (multivalueField == null) {
            return result;
        }
        if (multivalueField.getAssocValueKey() != null) {
            result.add(new BcField(multivalueField.getPopupBcName(), multivalueField.getAssocValueKey()).putAttribute(BcField.Attribute.WIDGET_ID, widget.getId()));
        }
        if (multivalueField.getDisplayedKey() != null) {
            result.add(new BcField(widget.getBc(), multivalueField.getDisplayedKey()).putAttribute(BcField.Attribute.WIDGET_ID, widget.getId()));
        }
        return result;
    }

    private MultivalueField getMultivalueField(FieldMeta.FieldMetaBase field) {
        if (field.getType().equals("multivalue") || field.getType().equals("multivalueHover")) {
            MultivalueFieldMeta multivalueField = (MultivalueFieldMeta)field;
            return new MultivalueField(multivalueField.getPopupBcName(), multivalueField.getAssocValueKey(), multivalueField.getDisplayedKey(), multivalueField.getAssociateFieldKey());
        }
        return null;
    }

    private List<PickListField> getPickLists(FieldMeta.FieldMetaBase field) {
        ArrayList<PickListField> pickLists = new ArrayList<PickListField>();
        if (field.getType().equals("pickList") || field.getType().equals("inline-pickList")) {
            PickListFieldMeta pickListField = (PickListFieldMeta)field;
            pickLists.add(new PickListField(pickListField.getPopupBcName(), pickListField.getPickMap()));
        }
        return pickLists;
    }

    protected Set<BcField> extractFieldsFromTitle(Widget widget, String title) {
        HashSet<BcField> fields = new HashSet<BcField>();
        if (title == null) {
            return fields;
        }
        String templateWithoutDefault = title.replaceAll("\\$\\{(\\w*)(:[\\w\u0430-\u044f\u0410-\u042f\u0451\u0401\\-,. ]*)?}", "\\$\\{$1}");
        for (JuelUtils.Property property : JuelUtils.getProperties((String)templateWithoutDefault)) {
            fields.add(new BcField(widget.getBc(), property.getIdentifier()).putAttribute(BcField.Attribute.WIDGET_ID, widget.getId()));
        }
        return fields;
    }
}

