/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.ui.field;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cxbox.api.util.i18n.LocalizationFormatter;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.meta.entity.Widget;
import org.cxbox.meta.ui.field.BaseFieldExtractor;
import org.cxbox.meta.ui.field.link.LinkFieldExtractor;
import org.cxbox.meta.ui.model.BcField;
import org.cxbox.meta.ui.model.json.field.FieldMeta;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ListFieldExtractor
extends BaseFieldExtractor {
    public ListFieldExtractor(@Autowired LinkFieldExtractor linkFieldExtractor) {
        super(linkFieldExtractor);
    }

    @Override
    public Set<BcField> extract(Widget widget) {
        HashSet<BcField> widgetFields = new HashSet<BcField>(this.extractFieldsFromTitle(widget, LocalizationFormatter.i18n((String)widget.getTitle())));
        for (FieldMeta field : (FieldMeta[])JsonUtils.readValue(FieldMeta[].class, (String)widget.getFields())) {
            widgetFields.addAll(this.extract(widget, field));
        }
        return widgetFields;
    }

    @Override
    public List<String> getSupportedTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("List");
        result.add("DataGrid");
        result.add("PickListPopup");
        result.add("Pivot");
        result.add("DimFilter");
        result.add("Steps");
        return result;
    }
}

