/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.ui.field;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.meta.entity.Widget;
import org.cxbox.meta.ui.field.FieldExtractor;
import org.cxbox.meta.ui.field.link.LinkFieldExtractor;
import org.cxbox.meta.ui.model.BcField;
import org.cxbox.meta.ui.model.json.PivotMeta;
import org.cxbox.meta.ui.model.json.field.FieldMeta;
import org.springframework.stereotype.Component;

@Component
public class PivotFieldExtractor
implements FieldExtractor {
    private final LinkFieldExtractor linkFieldExtractor;

    @Override
    public Set<BcField> extract(Widget widget) {
        HashSet<BcField> fields = new HashSet<BcField>();
        if (widget.getPivotFields() != null) {
            PivotMeta pivotMeta = (PivotMeta)JsonUtils.readValue(PivotMeta.class, (String)widget.getPivotFields());
            pivotMeta.getRows().forEach(row -> fields.addAll(this.extract(widget, (PivotMeta.TableColRow)row)));
            pivotMeta.getCols().forEach(col -> fields.addAll(this.extract(widget, (PivotMeta.TableColRow)col)));
            pivotMeta.getValues().forEach(value -> fields.addAll(this.extract(widget, (PivotMeta.TableValue)value)));
        }
        return fields;
    }

    private Set<BcField> extract(Widget widget, PivotMeta.TableColRow tableColRow) {
        Set<BcField> fields = this.linkFieldExtractor.extract(widget, tableColRow);
        if (tableColRow.getChildren() != null) {
            tableColRow.getChildren().forEach(child -> fields.addAll(this.extract(widget, (PivotMeta.TableColRow)child)));
        }
        return fields;
    }

    private Set<BcField> extract(Widget widget, PivotMeta.TableValue tableValue) {
        FieldMeta fieldMeta = tableValue.getField();
        HashSet<BcField> fields = new HashSet<BcField>(this.linkFieldExtractor.extract(widget, fieldMeta));
        fields.add(new BcField(widget.getBc(), fieldMeta.getKey()).putAttribute(BcField.Attribute.WIDGET_ID, widget.getId()));
        return fields;
    }

    @Override
    public List<String> getSupportedTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("PivotFields");
        return result;
    }

    @ConstructorProperties(value={"linkFieldExtractor"})
    @Generated
    public PivotFieldExtractor(LinkFieldExtractor linkFieldExtractor) {
        this.linkFieldExtractor = linkFieldExtractor;
    }
}

