/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.ui.field.link;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.cxbox.core.util.InstrumentationAwareReflectionUtils;
import org.cxbox.meta.entity.Widget;
import org.cxbox.meta.ui.field.CustomFieldExtractor;
import org.cxbox.meta.ui.field.link.LinkToField;
import org.cxbox.meta.ui.model.BcField;
import org.springframework.stereotype.Component;

@Component
public final class LinkFieldExtractor {
    private final CustomFieldExtractor customFieldExtractor;

    public Set<BcField> extract(Widget widget, Object object) {
        return this.extract(widget.getId(), widget.getBc(), object);
    }

    public Set<BcField> extract(Long widgetId, String bc, Object object) {
        HashSet<BcField> fields = new HashSet<BcField>();
        for (Field field : InstrumentationAwareReflectionUtils.getAllNonSyntheticFieldsList(object.getClass())) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(LinkToField.class) || field.get(object) == null) continue;
            fields.add(new BcField(bc, (String)field.get(object)).putAttribute(BcField.Attribute.WIDGET_ID, widgetId));
        }
        Set<BcField> customFields = this.customFieldExtractor.extract(widgetId, bc, object);
        fields.addAll(customFields);
        return fields;
    }

    @ConstructorProperties(value={"customFieldExtractor"})
    @Generated
    public LinkFieldExtractor(CustomFieldExtractor customFieldExtractor) {
        this.customFieldExtractor = customFieldExtractor;
    }
}

