/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.IUser;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.api.util.CxCollections;
import org.cxbox.api.util.Invoker;
import org.cxbox.core.service.ResponsibilitiesService;
import org.cxbox.dto.ScreenResponsibility;
import org.cxbox.meta.data.ViewDTO;
import org.cxbox.meta.entity.Responsibilities;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;

public class ResponsibilitiesServiceImpl
implements ResponsibilitiesService {
    private final MetaRepository metaRepository;
    private final CacheManager cacheManager;
    private final TransactionService txService;
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"userCache"}, key="{#root.methodName, #user.id, #userRole}")
    public Map<String, Boolean> getAvailableViews(IUser<Long> user, LOV userRole) {
        return this.metaRepository.getResponsibilityByUserAndRole(user, userRole, Responsibilities.ResponsibilityType.VIEW).stream().collect(Collectors.toMap(Responsibilities::getView, Responsibilities::isReadOnly, (x1, x2) -> x2));
    }

    public List<ScreenResponsibility> getAvailableScreensResponsibilities(IUser<Long> user, LOV userRole) {
        String screens = this.metaRepository.getResponsibilityByUserAndRole(user, userRole, Responsibilities.ResponsibilityType.SCREEN).stream().map(Responsibilities::getScreens).filter(StringUtils::isNotBlank).findFirst().orElse(null);
        ArrayList<ScreenResponsibility> result = new ArrayList<ScreenResponsibility>();
        if (StringUtils.isNotBlank((CharSequence)screens)) {
            result.addAll((Collection)this.objectMapper.readValue(screens, ScreenResponsibility.LIST_TYPE_REFERENCE));
        }
        return result;
    }

    public void invalidateCache() {
        this.txService.invokeAfterCompletion(Invoker.of(() -> {
            this.cacheManager.getCache("widgetcache").clear();
            this.cacheManager.getCache("userCache").clear();
        }));
    }

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"userCache"}, key="{#root.methodName, #screenName, #user.id, #userRole}")
    public List<String> getAvailableScreenViews(String screenName, IUser<Long> user, LOV userRole) {
        Set<String> availableViews = this.getAvailableViews(user, userRole).keySet();
        boolean getAll = Objects.equals(userRole, CoreDictionaries.InternalRole.ADMIN);
        Set screenViews = this.metaRepository.getAllScreens().get(screenName).getViews().stream().map(ViewDTO::getName).collect(Collectors.toSet());
        Set result = getAll ? screenViews : CxCollections.intersection(screenViews, availableViews);
        return new ArrayList<String>(result);
    }

    @ConstructorProperties(value={"metaRepository", "cacheManager", "txService", "objectMapper"})
    @Generated
    public ResponsibilitiesServiceImpl(MetaRepository metaRepository, CacheManager cacheManager, TransactionService txService, @Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        this.metaRepository = metaRepository;
        this.cacheManager = cacheManager;
        this.txService = txService;
        this.objectMapper = objectMapper;
    }
}

