/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.additionalFields;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.meta.additionalFields.AdditionalFieldsDTO;
import org.cxbox.meta.additionalFields.AdditionalFieldsService;
import org.cxbox.meta.entity.AdditionalFields;
import org.cxbox.meta.entity.AdditionalFields_;
import org.cxbox.model.core.dao.JpaDao;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class AdditionalFieldsImpl
implements AdditionalFieldsService {
    private final JpaDao jpaDao;
    private final SessionService service;
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;
    private final TransactionService transactionService;

    @Override
    public List<AdditionalFieldsDTO> createAdditionalFields(List<AdditionalFieldsDTO> additionalFieldsDTO) {
        ArrayList additionalFieldsList = new ArrayList();
        return (List)this.transactionService.invokeInTx(() -> {
            additionalFieldsDTO.stream().map(this::additionalFieldsFromDTO).forEach(af -> {
                af.setUserId(String.valueOf(this.service.getSessionUser().getId()));
                if (this.isExists((AdditionalFields)((Object)((Object)af)))) {
                    this.updateAdditionalFields((AdditionalFields)((Object)((Object)af)));
                } else {
                    this.jpaDao.save((Object)af);
                }
                additionalFieldsList.add(new AdditionalFieldsDTO((AdditionalFields)((Object)((Object)af))));
            });
            return additionalFieldsList;
        });
    }

    @Override
    public void deleteAdditionalFields(List<Long> ids) {
        this.transactionService.invokeInTx(() -> {
            ids.forEach(id -> this.jpaDao.delete(AdditionalFields.class, id));
            return null;
        });
    }

    @Override
    public List<AdditionalFieldsDTO> updateAdditionalFields(List<AdditionalFieldsDTO> additionalFieldsDTO) {
        ArrayList<AdditionalFieldsDTO> additionalFieldsDTOList = new ArrayList<AdditionalFieldsDTO>();
        this.transactionService.invokeInTx(() -> {
            additionalFieldsDTO.stream().map(this::additionalFieldsFromDTO).forEach(af -> {
                af.setUserId(String.valueOf(this.service.getSessionUser().getId()));
                if (this.isExists((AdditionalFields)((Object)((Object)af)))) {
                    this.updateAdditionalFields((AdditionalFields)((Object)((Object)af)));
                    additionalFieldsDTOList.add(new AdditionalFieldsDTO((AdditionalFields)((Object)((Object)af))));
                }
            });
            return null;
        });
        return additionalFieldsDTOList;
    }

    private boolean isExists(AdditionalFields additionalFields) {
        return this.jpaDao.exists(AdditionalFields.class, (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(AdditionalFields_.view), (Object)additionalFields.getView()), cb.equal((Expression)root.get(AdditionalFields_.widget), (Object)additionalFields.getWidget()), cb.equal((Expression)root.get(AdditionalFields_.userId), (Object)String.valueOf(this.service.getSessionUser().getId()))}));
    }

    private void updateAdditionalFields(AdditionalFields additionalFieldsForUpdate) {
        this.jpaDao.update(AdditionalFields.class, (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(AdditionalFields_.view), (Object)additionalFieldsForUpdate.getView()), cb.equal((Expression)root.get(AdditionalFields_.widget), (Object)additionalFieldsForUpdate.getWidget()), cb.equal((Expression)root.get(AdditionalFields_.userId), (Object)String.valueOf(this.service.getSessionUser().getId()))}), (update, root, cb) -> {
            update.set(root.get(AdditionalFields_.orderFields), cb.literal((Object)Optional.ofNullable(additionalFieldsForUpdate.getOrderFields()).orElse("[]")));
            update.set(root.get(AdditionalFields_.addedToAdditionalFields), cb.literal((Object)Optional.ofNullable(additionalFieldsForUpdate.getAddedToAdditionalFields()).orElse("[]")));
            update.set(root.get(AdditionalFields_.removedFromAdditionalFields), cb.literal((Object)Optional.ofNullable(additionalFieldsForUpdate.getRemovedFromAdditionalFields()).orElse("[]")));
        });
    }

    private AdditionalFields additionalFieldsFromDTO(AdditionalFieldsDTO additionalFieldsDTO) {
        return new AdditionalFields().setAddedToAdditionalFields(this.objectMapper.writeValueAsString(additionalFieldsDTO.getAddedToAdditionalFields())).setRemovedFromAdditionalFields(this.objectMapper.writeValueAsString(additionalFieldsDTO.getRemovedFromAdditionalFields())).setOrderFields(this.objectMapper.writeValueAsString(additionalFieldsDTO.getOrderFields())).setWidget(additionalFieldsDTO.getWidget()).setView(additionalFieldsDTO.getView());
    }

    @ConstructorProperties(value={"jpaDao", "service", "objectMapper", "transactionService"})
    @Generated
    public AdditionalFieldsImpl(JpaDao jpaDao, SessionService service, @Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper, TransactionService transactionService) {
        this.jpaDao = jpaDao;
        this.service = service;
        this.objectMapper = objectMapper;
        this.transactionService = transactionService;
    }
}

