/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.filterGroup;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.meta.data.FilterGroupDTO;
import org.cxbox.meta.entity.FilterGroup;
import org.cxbox.meta.filterGroup.PersonalFilterGroupService;
import org.cxbox.model.core.dao.JpaDao;
import org.springframework.stereotype.Service;

@Service
public class PersonalFilterGroupServiceImpl
implements PersonalFilterGroupService {
    private final JpaDao jpaDao;
    private final SessionService service;
    private final TransactionService transactionService;

    @Override
    public List<FilterGroupDTO> create(List<FilterGroupDTO> filterGroupDTOList) {
        ArrayList<FilterGroupDTO> filterGroupsDTO = new ArrayList<FilterGroupDTO>();
        this.transactionService.invokeInTx(() -> {
            filterGroupDTOList.forEach(fgDTO -> {
                Long id = (Long)this.jpaDao.save((Object)this.filterGroupFromDTO((FilterGroupDTO)fgDTO).setUserId(String.valueOf(this.service.getSessionUser().getId())));
                fgDTO.setId(id.toString());
                filterGroupsDTO.add((FilterGroupDTO)fgDTO);
            });
            return null;
        });
        return filterGroupsDTO;
    }

    @Override
    public void delete(List<Long> ids) {
        this.transactionService.invokeInTx(() -> {
            ids.forEach(id -> this.jpaDao.delete(FilterGroup.class, id));
            return null;
        });
    }

    private FilterGroup filterGroupFromDTO(FilterGroupDTO filterGroupDTO) {
        return new FilterGroup().setFilters(filterGroupDTO.getFilters()).setName(filterGroupDTO.getName()).setBc(filterGroupDTO.getBc());
    }

    @ConstructorProperties(value={"jpaDao", "service", "transactionService"})
    @Generated
    public PersonalFilterGroupServiceImpl(JpaDao jpaDao, SessionService service, TransactionService transactionService) {
        this.jpaDao = jpaDao;
        this.service = service;
        this.transactionService = transactionService;
    }
}

