/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cxbox.meta.data.ViewDTO;
import org.cxbox.meta.data.ViewWidgetGroupDTO;
import org.cxbox.meta.metahotreload.dto.ViewSourceDTO;
import org.cxbox.meta.metahotreload.dto.WidgetSourceDTO;
import org.cxbox.meta.metahotreload.mapper.WidgetMapper;
import org.cxbox.meta.metahotreload.util.JsonUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ViewMapper {
    private final WidgetMapper widgetMapper;
    private final AtomicLong viewSeq = new AtomicLong(0L);
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;

    public ViewDTO map(ViewSourceDTO dto, Map<String, WidgetSourceDTO> widgetNameToWidget) {
        AtomicInteger viewWidgetSeq = new AtomicInteger(0);
        ViewDTO viewDto = new ViewDTO().setName(dto.getName()).setTemplate(dto.getTemplate()).setTitle(dto.getTitle()).setUrl(dto.getUrl()).setCustomizable(Optional.ofNullable(dto.getCustomizable()).orElse(false)).setEditable(Optional.ofNullable(dto.getEditable()).orElse(false)).setIgnoreHistory(Optional.ofNullable(dto.getIgnoreHistory()).orElse(false)).setOptions(JsonUtils.serializeOrElseEmptyArr(this.objectMapper, dto.getOptions())).setReadOnly(false).setGroups(dto.getGroups().stream().map(e -> new ViewWidgetGroupDTO().setWidgetNames(e.getWidgetNames())).collect(Collectors.toList())).setWidgets(dto.getWidgets().stream().map(vw -> this.widgetMapper.map((WidgetSourceDTO)widgetNameToWidget.get(vw.getWidgetName()), (ViewSourceDTO.ViewWidgetSourceDTO)vw)).map(vw -> {
            vw.setWidgetId(viewWidgetSeq.getAndIncrement());
            vw.setId(vw.getId());
            return vw;
        }).collect(Collectors.toList()));
        viewDto.setId(this.viewSeq.getAndIncrement());
        return viewDto;
    }

    @ConstructorProperties(value={"widgetMapper", "objectMapper"})
    @Generated
    public ViewMapper(WidgetMapper widgetMapper, @Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        this.widgetMapper = widgetMapper;
        this.objectMapper = objectMapper;
    }
}

