/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.SerializationUtils;
import org.cxbox.api.service.session.IUser;
import org.cxbox.core.service.ResponsibilitiesService;
import org.cxbox.dto.ScreenResponsibility;
import org.cxbox.meta.additionalFields.AdditionalFieldsDTO;
import org.cxbox.meta.data.FilterGroupDTO;
import org.cxbox.meta.data.ScreenDTO;
import org.cxbox.meta.data.ViewDTO;
import org.cxbox.meta.entity.AdditionalFields;
import org.cxbox.meta.entity.AdditionalFields_;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.cxbox.model.core.dao.JpaDao;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class UserMetaProvider {
    private final ResponsibilitiesService responsibilitiesService;
    private final MetaRepository metaRepository;
    private final JpaDao jpaDao;
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"userCache"}, key="{#root.methodName, #user.id, #userRole}")
    public Map<String, ScreenResponsibility> getAvailableScreensResponsibilities(IUser<Long> user, Set<String> userRole) {
        Map<String, ScreenResponsibility> allScreens = this.metaRepository.getAllScreens();
        Map allUserScreens = (Map)((Object)SerializationUtils.clone((Serializable)((HashMap)allScreens)));
        Map userViewToReadOnlyFlg = this.responsibilitiesService.getAvailableViews(user, userRole);
        allUserScreens.values().forEach(s -> {
            List<ViewDTO> userViews = ((ScreenDTO)((Object)((Object)s.getMeta()))).getViews().stream().filter(v -> v.getName() != null && userViewToReadOnlyFlg.containsKey(v.getName())).toList();
            ((ScreenDTO)((Object)((Object)s.getMeta()))).setViews(userViews);
        });
        Map<String, List<FilterGroupDTO>> personalFilterGroups = this.metaRepository.getPersonalFilterGroups(user);
        allUserScreens.values().forEach(s -> ((ScreenDTO)((Object)((Object)s.getMeta()))).getBo().getBc().forEach(bc -> bc.getFilterGroups().addAll(personalFilterGroups.getOrDefault(bc.getName(), new ArrayList()))));
        List<AdditionalFieldsDTO> additionalFieldsDTO = this.getAdditionalFieldsDTO(user);
        allUserScreens.values().forEach(s -> ((ScreenDTO)((Object)((Object)s.getMeta()))).getViews().forEach(v -> v.getWidgets().forEach(w -> {
            AdditionalFieldsDTO pers = additionalFieldsDTO.stream().filter(add -> v.getName().equals(add.getView()) && w.getName().equals(add.getWidget())).findFirst().orElse(null);
            w.setPersonalFields(pers);
        })));
        return allUserScreens.entrySet().stream().filter(e -> {
            List<ViewDTO> views = ((ScreenDTO)((Object)((Object)((ScreenResponsibility)e.getValue()).getMeta()))).getViews();
            return views != null && !views.isEmpty();
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private List<AdditionalFieldsDTO> getAdditionalFieldsDTO(IUser<Long> user) {
        return this.jpaDao.getList(AdditionalFields.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(AdditionalFields_.userId), (Object)String.valueOf(user.getId()))})).stream().map(field -> {
            AdditionalFieldsDTO additionalFieldsDTO = new AdditionalFieldsDTO((AdditionalFields)((Object)field));
            additionalFieldsDTO.setAddedToAdditionalFields(this.getListFromJson(field.getAddedToAdditionalFields()));
            additionalFieldsDTO.setOrderFields(this.getListFromJson(field.getOrderFields()));
            additionalFieldsDTO.setRemovedFromAdditionalFields(this.getListFromJson(field.getRemovedFromAdditionalFields()));
            return additionalFieldsDTO;
        }).collect(Collectors.toList());
    }

    private List<String> getListFromJson(String json) {
        return (List)this.objectMapper.readValue(json, List.class);
    }

    @ConstructorProperties(value={"responsibilitiesService", "metaRepository", "jpaDao", "objectMapper"})
    @Generated
    public UserMetaProvider(ResponsibilitiesService responsibilitiesService, MetaRepository metaRepository, JpaDao jpaDao, @Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        this.responsibilitiesService = responsibilitiesService;
        this.metaRepository = metaRepository;
        this.jpaDao = jpaDao;
        this.objectMapper = objectMapper;
    }
}

