/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.service.session.IUser;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.api.util.CxCollections;
import org.cxbox.api.util.Invoker;
import org.cxbox.core.service.ResponsibilitiesService;
import org.cxbox.dto.ScreenResponsibility;
import org.cxbox.meta.data.ScreenDTO;
import org.cxbox.meta.data.ViewDTO;
import org.cxbox.meta.entity.Responsibilities;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;

public class ResponsibilitiesServiceImpl
implements ResponsibilitiesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResponsibilitiesServiceImpl.class);
    private final MetaRepository metaRepository;
    private final CacheManager cacheManager;
    private final TransactionService txService;
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"userCache"}, key="{#root.methodName, #user.id, #userRole}")
    public Map<String, Boolean> getAvailableViews(IUser<Long> user, @NonNull Set<String> userRole) {
        if (userRole == null) {
            throw new NullPointerException("userRole is marked non-null but is null");
        }
        return this.metaRepository.getResponsibilityByUserAndRole(user, userRole, Responsibilities.ResponsibilityType.VIEW).stream().collect(Collectors.toMap(Responsibilities::getView, Responsibilities::isReadOnly, (x1, x2) -> x2));
    }

    public List<ScreenResponsibility> getOverrideScreensResponsibilities(IUser<Long> user, @NonNull Set<String> userRole) {
        if (userRole == null) {
            throw new NullPointerException("userRole is marked non-null but is null");
        }
        String screens = this.metaRepository.getResponsibilityByUserAndRole(user, userRole, Responsibilities.ResponsibilityType.SCREEN).stream().map(Responsibilities::getScreens).filter(StringUtils::isNotBlank).findFirst().orElse(null);
        ArrayList<ScreenResponsibility> result = new ArrayList<ScreenResponsibility>();
        if (StringUtils.isNotBlank((CharSequence)screens)) {
            try {
                result.addAll((Collection)this.objectMapper.readValue(screens, ScreenResponsibility.LIST_TYPE_REFERENCE));
            }
            catch (Exception e) {
                String example = "[{\n\"name\": \"client\",\n\"text\": \"Client\",\n\"icon\": \"team\",\n\"order\": 999\n}]\n";
                log.error("Screen params (name*, text, icon, order) override for role " + userRole + " is skipped. Default values from *.screen.json will be used.  \n Reason: cannot deserialize " + screens + " to org.cxbox.dto.ScreenResponsibility array.  \n Valid example is (name is required. other fields are optional): " + example, (Throwable)e);
            }
        }
        return result;
    }

    public void invalidateCache() {
        this.txService.invokeAfterCompletion(Invoker.of(() -> {
            this.cacheManager.getCache("widgetcache").clear();
            this.cacheManager.getCache("userCache").clear();
        }));
    }

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"userCache"}, key="{#root.methodName, #screenName, #user.id, #userRole}")
    public List<String> getAvailableScreenViews(String screenName, IUser<Long> user, @NonNull Set<String> userRole) {
        if (userRole == null) {
            throw new NullPointerException("userRole is marked non-null but is null");
        }
        Set<String> availableViews = this.getAvailableViews(user, userRole).keySet();
        boolean getAll = Objects.equals(userRole, "ADMIN");
        Set screenViews = ((ScreenDTO)((Object)this.metaRepository.getAllScreens().get(screenName).getMeta())).getViews().stream().map(ViewDTO::getName).collect(Collectors.toSet());
        Set result = getAll ? screenViews : CxCollections.intersection(screenViews, availableViews);
        return new ArrayList<String>(result);
    }

    @ConstructorProperties(value={"metaRepository", "cacheManager", "txService", "objectMapper"})
    @Generated
    public ResponsibilitiesServiceImpl(MetaRepository metaRepository, CacheManager cacheManager, TransactionService txService, @Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        this.metaRepository = metaRepository;
        this.cacheManager = cacheManager;
        this.txService = txService;
        this.objectMapper = objectMapper;
    }
}

