/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.ui.field;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.meta.data.WidgetDTO;
import org.cxbox.meta.ui.field.FieldExtractor;
import org.cxbox.meta.ui.model.BcField;
import org.cxbox.meta.ui.model.json.Condition;
import org.springframework.stereotype.Component;

@Component
public class ShowConditionFieldExtractor
implements FieldExtractor {
    @Override
    public Set<BcField> extract(WidgetDTO widget) {
        HashSet<BcField> fields = new HashSet<BcField>();
        if (!Objects.equals(widget.getShowCondition(), "[]")) {
            Condition condition = (Condition)JsonUtils.readValue(Condition.class, (String)widget.getShowCondition());
            if (condition.getParams() != null) {
                fields.add(this.getField(widget, condition, condition.getParams()));
            }
            if (condition.getMultipleParams() != null) {
                for (Condition.IConditionFieldEqualityParams multipleParam : condition.getMultipleParams()) {
                    fields.add(this.getField(widget, condition, multipleParam));
                }
            }
        }
        return fields;
    }

    private BcField getField(WidgetDTO widget, Condition condition, Condition.IConditionFieldEqualityParams params) {
        String bc = condition.getBcName() == null ? widget.getBcName() : condition.getBcName();
        return new BcField(bc, params.getFieldKey()).putAttribute(BcField.Attribute.WIDGET_NAME, widget.getName());
    }

    @Override
    public List<String> getSupportedTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ShowConditionFields");
        return result;
    }
}

