/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.SerializationUtils;
import org.cxbox.api.ScreenResponsibilityService;
import org.cxbox.api.service.session.IUser;
import org.cxbox.core.service.ResponsibilitiesService;
import org.cxbox.dto.ScreenResponsibility;
import org.cxbox.meta.data.ScreenDTO;
import org.cxbox.meta.entity.ResponsibilitiesAction;
import org.cxbox.meta.metahotreload.conf.properties.MetaConfigurationProperties;
import org.cxbox.meta.metahotreload.repository.UserMetaProvider;
import org.cxbox.model.core.dao.JpaDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Service
@Transactional
public class ScreenResponsibilityServiceImpl
implements ScreenResponsibilityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScreenResponsibilityServiceImpl.class);
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;
    private final ResponsibilitiesService respService;
    private final UserMetaProvider userMetaProvider;
    private final JpaDao jpaDao;
    private final MetaConfigurationProperties metaConfigurationProperties;

    public List<ScreenResponsibility> getScreens(IUser<Long> user, Set<String> userRole) {
        Map<String, ScreenResponsibility> allUserScreens = this.userMetaProvider.getAvailableScreensResponsibilities(user, userRole);
        this.screenOverride(user, userRole, allUserScreens);
        this.widgetActionGroupsOverride(user, userRole, allUserScreens);
        return allUserScreens.values().stream().sorted(Comparator.comparing(ScreenResponsibility::getOrder).thenComparing(ScreenResponsibility::getName)).toList();
    }

    public void screenOverride(IUser<Long> user, Set<String> userRole, Map<String, ScreenResponsibility> allUserScreens) {
        List allOverrides = this.respService.getOverrideScreensResponsibilities(user, userRole);
        allOverrides.forEach(override -> allUserScreens.computeIfPresent(override.getName(), (key, old) -> new ScreenResponsibility().setId(old.getId()).setUrl(old.getUrl()).setMeta(old.getMeta()).setName(override.getName()).setOrder(Optional.ofNullable(override.getOrder()).orElse(Optional.ofNullable(old.getOrder()).orElse(0))).setText(Optional.ofNullable(override.getText()).orElse(old.getText())).setIcon(Optional.ofNullable(override.getIcon()).orElse(old.getIcon()))));
    }

    public void widgetActionGroupsOverride(IUser<Long> user, Set<String> userRole, Map<String, ScreenResponsibility> allUserScreens) {
        List roleAction = this.jpaDao.getList(ResponsibilitiesAction.class);
        if (!this.metaConfigurationProperties.isWidgetActionGroupsEnabled()) {
            allUserScreens.values().stream().map(s -> (ScreenDTO)((Object)((Object)s.getMeta()))).forEach(sc -> sc.getViews().forEach(v -> {
                v.setWidgets(v.getWidgets().stream().map(SerializationUtils::clone).toList());
                v.getWidgets().forEach(w -> {
                    try {
                        ObjectNode widgetJson = (ObjectNode)this.objectMapper.readValue(this.objectMapper.writeValueAsString(w), ObjectNode.class);
                        ObjectNode optionsNode = this.getObjectPropOrElseCreate(widgetJson, "options");
                        ObjectNode actionsGroups = this.getObjectPropReCreate(optionsNode, "actionGroups");
                        ArrayNode include = this.getArrayPropOrElseCreate(actionsGroups, "include");
                        roleAction.stream().filter(ra -> ra.isAvailable(userRole, v.getName(), w.getName())).map(ResponsibilitiesAction::getAction).forEach(arg_0 -> ((ArrayNode)include).add(arg_0));
                        w.setOptions(this.objectMapper.writeValueAsString((Object)optionsNode));
                    }
                    catch (JsonProcessingException e) {
                        throw new IllegalStateException(e);
                    }
                });
            }));
        }
    }

    private ObjectNode getObjectPropOrElseCreate(ObjectNode parent, String propName) {
        JsonNode optionsNode = parent.get(propName);
        if (optionsNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)optionsNode;
            return objectNode;
        }
        parent.set(propName, (JsonNode)this.objectMapper.createObjectNode());
        return (ObjectNode)parent.get(propName);
    }

    private ObjectNode getObjectPropReCreate(ObjectNode parent, String propName) {
        parent.set(propName, (JsonNode)this.objectMapper.createObjectNode());
        return (ObjectNode)parent.get(propName);
    }

    private ArrayNode getArrayPropOrElseCreate(ObjectNode parent, String propName) {
        JsonNode optionsNode = parent.get(propName);
        if (optionsNode instanceof ArrayNode) {
            ArrayNode objectNode = (ArrayNode)optionsNode;
            return objectNode;
        }
        parent.set(propName, (JsonNode)this.objectMapper.createArrayNode());
        return (ArrayNode)parent.get(propName);
    }

    @ConstructorProperties(value={"objectMapper", "respService", "userMetaProvider", "jpaDao", "metaConfigurationProperties"})
    @Generated
    public ScreenResponsibilityServiceImpl(@Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper, ResponsibilitiesService respService, UserMetaProvider userMetaProvider, JpaDao jpaDao, MetaConfigurationProperties metaConfigurationProperties) {
        this.objectMapper = objectMapper;
        this.respService = respService;
        this.userMetaProvider = userMetaProvider;
        this.jpaDao = jpaDao;
        this.metaConfigurationProperties = metaConfigurationProperties;
    }
}

