/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.conf.properties;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="cxbox.meta")
public class MetaConfigurationProperties {
    private boolean devPanelEnabled = false;
    private boolean viewAllowedRolesEnabled = false;
    private boolean widgetActionGroupsEnabled = true;
    private boolean widgetActionGroupsCompact = true;
    @NotNull(message="Path to meta files directory. Supports file: or classpath: prefix. Example of usage is: applicationContext.getResources(directory + widgetPath)")
    private @NotNull(message="Path to meta files directory. Supports file: or classpath: prefix. Example of usage is: applicationContext.getResources(directory + widgetPath)") String directory = "classpath*:db/migration/liquibase/data/latest";
    @NotBlank(message="Path to widget files from MetaConfigurationProperties.directory")
    private @NotBlank(message="Path to widget files from MetaConfigurationProperties.directory") String widgetPath = "/**/*.widget.json";
    @NotBlank(message="Path to view files from MetaConfigurationProperties.directory")
    private @NotBlank(message="Path to view files from MetaConfigurationProperties.directory") String viewPath = "/**/*.view.json";
    @NotBlank(message="Path to screen files from MetaConfigurationProperties.directory")
    private @NotBlank(message="Path to screen files from MetaConfigurationProperties.directory") String screenPath = "/**/*.screen.json";
    @NotBlank(message="Path to sqlbc files from MetaConfigurationProperties.directory")
    private @NotBlank(message="Path to sqlbc files from MetaConfigurationProperties.directory") String bcPath = "/**/*.sqlbc.json";
    @Positive(message="Number of rows on bc by default (can be override with BC_PROPERTIES.csv)")
    private @Positive(message="Number of rows on bc by default (can be override with BC_PROPERTIES.csv)") Long bcDefaultPageLimit = 5L;

    @Generated
    public boolean isDevPanelEnabled() {
        return this.devPanelEnabled;
    }

    @Generated
    public boolean isViewAllowedRolesEnabled() {
        return this.viewAllowedRolesEnabled;
    }

    @Generated
    public boolean isWidgetActionGroupsEnabled() {
        return this.widgetActionGroupsEnabled;
    }

    @Generated
    public boolean isWidgetActionGroupsCompact() {
        return this.widgetActionGroupsCompact;
    }

    @Generated
    public String getDirectory() {
        return this.directory;
    }

    @Generated
    public String getWidgetPath() {
        return this.widgetPath;
    }

    @Generated
    public String getViewPath() {
        return this.viewPath;
    }

    @Generated
    public String getScreenPath() {
        return this.screenPath;
    }

    @Generated
    public String getBcPath() {
        return this.bcPath;
    }

    @Generated
    public Long getBcDefaultPageLimit() {
        return this.bcDefaultPageLimit;
    }

    @Generated
    public void setDevPanelEnabled(boolean devPanelEnabled) {
        this.devPanelEnabled = devPanelEnabled;
    }

    @Generated
    public void setViewAllowedRolesEnabled(boolean viewAllowedRolesEnabled) {
        this.viewAllowedRolesEnabled = viewAllowedRolesEnabled;
    }

    @Generated
    public void setWidgetActionGroupsEnabled(boolean widgetActionGroupsEnabled) {
        this.widgetActionGroupsEnabled = widgetActionGroupsEnabled;
    }

    @Generated
    public void setWidgetActionGroupsCompact(boolean widgetActionGroupsCompact) {
        this.widgetActionGroupsCompact = widgetActionGroupsCompact;
    }

    @Generated
    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Generated
    public void setWidgetPath(String widgetPath) {
        this.widgetPath = widgetPath;
    }

    @Generated
    public void setViewPath(String viewPath) {
        this.viewPath = viewPath;
    }

    @Generated
    public void setScreenPath(String screenPath) {
        this.screenPath = screenPath;
    }

    @Generated
    public void setBcPath(String bcPath) {
        this.bcPath = bcPath;
    }

    @Generated
    public void setBcDefaultPageLimit(Long bcDefaultPageLimit) {
        this.bcDefaultPageLimit = bcDefaultPageLimit;
    }
}

