/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.metahotreload.service;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.cxbox.api.MetaHotReloadService;
import org.cxbox.api.data.dictionary.InternalRole;
import org.cxbox.api.service.session.InternalAuthorizationService;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.dictionary.DictionaryProvider;
import org.cxbox.meta.data.ScreenDTO;
import org.cxbox.meta.data.ViewDTO;
import org.cxbox.meta.entity.Responsibilities;
import org.cxbox.meta.entity.ResponsibilitiesAction;
import org.cxbox.meta.metahotreload.conf.properties.MetaConfigurationProperties;
import org.cxbox.meta.metahotreload.dto.ScreenSourceDto;
import org.cxbox.meta.metahotreload.dto.ViewSourceDTO;
import org.cxbox.meta.metahotreload.dto.WidgetSourceDTO;
import org.cxbox.meta.metahotreload.repository.MetaRepository;
import org.cxbox.meta.metahotreload.service.MetaResourceReaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaHotReloadServiceImpl
implements MetaHotReloadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaHotReloadServiceImpl.class);
    protected final MetaConfigurationProperties config;
    protected final MetaResourceReaderService metaResourceReaderService;
    protected final InternalAuthorizationService authzService;
    protected final TransactionService txService;
    protected final MetaRepository metaRepository;
    private final Optional<DictionaryProvider> dictionaryProvider;

    private static Stream<ViewSourceDTO> getViewsByWidget(List<ViewSourceDTO> viewDtos, WidgetSourceDTO widget) {
        return viewDtos.stream().filter(view -> view.getWidgets().stream().anyMatch(vw -> Objects.equals(vw.getWidgetName(), widget.getName())));
    }

    private static Stream<String> parseIncludeObject(Map actionOrGroupProps) {
        Object groupIncludeProp = actionOrGroupProps.getOrDefault("include", null);
        ArrayList<String> groupIncludes = new ArrayList<String>();
        if (groupIncludeProp == null) {
            Object groupNameProp = actionOrGroupProps.getOrDefault("type", null);
            if (groupNameProp instanceof String) {
                String groupNamePropStr = groupNameProp;
                groupIncludes.add(groupNamePropStr);
            }
        } else if (groupIncludeProp instanceof List) {
            List groupIncludeList = groupIncludeProp;
            groupIncludeList.forEach(groupInclude -> {
                if (groupInclude instanceof String) {
                    String groupIncludeStr = (String)groupInclude;
                    groupIncludes.add(groupIncludeStr);
                } else {
                    log.warn("Not supported format for migration, so entry " + JsonUtils.writeValue((Object)groupInclude) + " will be ignored");
                }
            });
        } else {
            log.warn("Not supported format for migration, so entry " + JsonUtils.writeValue(groupIncludeProp) + " will be ignored");
        }
        return groupIncludes.stream();
    }

    public void loadMeta() {
        List<ScreenSourceDto> screenDtos = this.metaResourceReaderService.getScreens();
        List<ViewSourceDTO> viewDtos = this.metaResourceReaderService.getViews();
        Map<WidgetSourceDTO, String> widgetDtos = this.metaResourceReaderService.getWidgets().stream().collect(Collectors.toMap(w -> w, w -> JsonUtils.writeValue((Object)w.getOptions())));
        this.authzService.loginAs(this.authzService.createAuthentication(InternalAuthorizationService.VANILLA));
        this.txService.invokeInTx(() -> {
            this.metaRepository.deleteAllMeta();
            this.responsibilitiesActionProcess(widgetDtos, viewDtos);
            this.responsibilitiesProcess(screenDtos, viewDtos);
            this.loadMetaAfterProcess();
            return null;
        });
    }

    public void responsibilitiesProcess(List<ScreenSourceDto> screenDtos, List<ViewSourceDTO> viewDtos) {
        if (this.config.isViewAllowedRolesEnabled()) {
            HashMap viewToScreenMap = new HashMap();
            this.metaRepository.getAllScreens().forEach((screenName, screenDto) -> ((ScreenDTO)((Object)((Object)screenDto.getMeta()))).getViews().stream().map(ViewDTO::getName).forEach(viewName -> viewToScreenMap.put(viewName, screenName)));
            ArrayList<Responsibilities> responsibilities = new ArrayList<Responsibilities>();
            viewDtos.forEach(view -> view.getRolesAllowed().forEach(role -> responsibilities.add(new Responsibilities().setResponsibilityType(Responsibilities.ResponsibilityType.VIEW).setInternalRoleCD((String)role).setView(view.getName()))));
            this.metaRepository.deleteAndSaveResponsibilities(responsibilities);
        }
    }

    private void responsibilitiesActionProcess(Map<WidgetSourceDTO, String> widgetDtos, List<ViewSourceDTO> viewDtos) {
        if (this.config.isWidgetActionGroupsEnabled()) {
            Map<WidgetSourceDTO, List<String>> widgetsToInclude = this.extractWidgetActionGroupsInclude(widgetDtos);
            ArrayList<ResponsibilitiesAction> responsibilitiesActions = new ArrayList<ResponsibilitiesAction>();
            if (this.config.isWidgetActionGroupsCompact()) {
                widgetsToInclude.forEach((widget, actionList) -> actionList.forEach(action -> responsibilitiesActions.add(new ResponsibilitiesAction().setInternalRoleCD("*").setAction((String)action).setView("*").setWidget(widget.getName()))));
            } else {
                List<String> roles = this.getInternalRoles().orElse(List.of("*"));
                widgetsToInclude.forEach((widget, actionList) -> actionList.forEach(action -> MetaHotReloadServiceImpl.getViewsByWidget(viewDtos, widget).forEach(view -> roles.forEach(role -> responsibilitiesActions.add(new ResponsibilitiesAction().setInternalRoleCD((String)role).setAction((String)action).setView(view.getName()).setWidget(widget.getName()))))));
            }
            this.metaRepository.deleteAndSaveResponsibilitiesAction(responsibilitiesActions);
            log.info(widgetsToInclude.toString());
        }
    }

    private Map<WidgetSourceDTO, List<String>> extractWidgetActionGroupsInclude(Map<WidgetSourceDTO, String> widgetDtos) {
        return widgetDtos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Optional.ofNullable((WidgetSourceDTO.Options)JsonUtils.readValue(WidgetSourceDTO.Options.class, (String)((String)entry.getValue()))).map(WidgetSourceDTO.Options::getActionGroups).map(WidgetSourceDTO.ActionGroupsDTO::getInclude).map(inc -> inc.stream().flatMap(actionOrGroup -> {
            if (actionOrGroup instanceof String) {
                String str = (String)actionOrGroup;
                return Stream.of(str);
            }
            if (actionOrGroup instanceof Map) {
                Map actionOrGroupProps = (Map)actionOrGroup;
                return MetaHotReloadServiceImpl.parseIncludeObject(actionOrGroupProps);
            }
            log.warn("Not supported format for migration, so entry " + JsonUtils.writeValue((Object)actionOrGroup) + " will be ignored");
            return null;
        }).filter(Objects::nonNull).toList()).orElse(new ArrayList())));
    }

    private Optional<List<String>> getInternalRoles() {
        return this.dictionaryProvider.map(dp -> dp.getAll(InternalRole.class).stream().map(InternalRole::key).toList());
    }

    protected void loadMetaAfterProcess() {
    }

    @ConstructorProperties(value={"config", "metaResourceReaderService", "authzService", "txService", "metaRepository", "dictionaryProvider"})
    @Generated
    public MetaHotReloadServiceImpl(MetaConfigurationProperties config, MetaResourceReaderService metaResourceReaderService, InternalAuthorizationService authzService, TransactionService txService, MetaRepository metaRepository, Optional<DictionaryProvider> dictionaryProvider) {
        this.config = config;
        this.metaResourceReaderService = metaResourceReaderService;
        this.authzService = authzService;
        this.txService = txService;
        this.metaRepository = metaRepository;
        this.dictionaryProvider = dictionaryProvider;
    }
}

