/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.meta.ui.field;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.meta.data.WidgetDTO;
import org.cxbox.meta.ui.field.BaseFieldExtractor;
import org.cxbox.meta.ui.field.link.LinkFieldExtractor;
import org.cxbox.meta.ui.model.BcField;
import org.cxbox.meta.ui.model.json.field.FieldGroup;
import org.cxbox.meta.ui.model.json.field.FieldMeta;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InfoFieldExtractor
extends BaseFieldExtractor {
    public InfoFieldExtractor(@Autowired LinkFieldExtractor linkFieldExtractor) {
        super(linkFieldExtractor);
    }

    @Override
    public Set<BcField> extract(WidgetDTO widget) {
        HashSet<BcField> widgetFields = new HashSet<BcField>(this.extractFieldsFromTitle(widget, widget.getTitle()));
        FieldMeta[] fieldMetas = (FieldMeta[])JsonUtils.readValue(FieldMeta[].class, (String)widget.getFields());
        FieldGroup[] fieldGroups = (FieldGroup[])JsonUtils.readValue(FieldGroup[].class, (String)widget.getFields());
        for (FieldMeta field : fieldMetas) {
            if (field.getKey() == null) continue;
            widgetFields.addAll(this.extract(widget, field));
        }
        for (FieldGroup group : fieldGroups) {
            if (group.getChildren() == null) continue;
            for (FieldMeta field : group.getChildren()) {
                widgetFields.addAll(this.extract(widget, field));
            }
        }
        return widgetFields;
    }

    @Override
    public List<String> getSupportedTypes() {
        return List.of("Info");
    }

    @Override
    public int getPriority() {
        return 1;
    }
}

